/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.core.WriteMessage;
import com.google.code.yanf4j.core.impl.FutureImpl;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.OperationStatus;
import net.rubyeye.xmemcached.exception.MemcachedClientException;
import net.rubyeye.xmemcached.exception.MemcachedDecodeException;
import net.rubyeye.xmemcached.exception.MemcachedServerException;
import net.rubyeye.xmemcached.exception.UnknownCommandException;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command
implements WriteMessage {
    public static final byte REQUEST_MAGIC_NUMBER = -128;
    public static final byte RESPONSE_MAGIC_NUMBER = -127;
    private boolean added;
    protected String key;
    protected byte[] keyBytes;
    protected Object result;
    protected CountDownLatch latch;
    protected CommandType commandType;
    protected Exception exception;
    protected IoBuffer ioBuffer;
    protected volatile boolean cancel;
    protected OperationStatus status;
    protected int mergeCount;
    private int copiedMergeCount;
    protected Transcoder transcoder;
    protected boolean noreply;
    protected FutureImpl<Boolean> writeFuture;

    public boolean isAdded() {
        return this.added;
    }

    public void setAdded(boolean added) {
        this.added = added;
    }

    @Override
    public final Object getMessage() {
        return this;
    }

    @Override
    public final synchronized IoBuffer getWriteBuffer() {
        return this.getIoBuffer();
    }

    @Override
    public void setWriteBuffer(IoBuffer buffers) {
    }

    public final byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public final void setKeyBytes(byte[] keyBytes) {
        this.keyBytes = keyBytes;
    }

    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    public int getMergeCount() {
        return this.mergeCount;
    }

    public Transcoder getTranscoder() {
        return this.transcoder;
    }

    public void setTranscoder(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    public void setMergeCount(int mergetCount) {
        this.mergeCount = mergetCount;
        this.copiedMergeCount = mergetCount;
    }

    public int getCopiedMergeCount() {
        return this.copiedMergeCount;
    }

    public Command() {
        this.copiedMergeCount = this.mergeCount = -1;
        this.status = OperationStatus.SENDING;
    }

    public Command(String key, byte[] keyBytes, CountDownLatch latch) {
        this.copiedMergeCount = this.mergeCount = -1;
        this.key = key;
        this.keyBytes = keyBytes;
        this.status = OperationStatus.SENDING;
        this.latch = latch;
    }

    public Command(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch) {
        this.copiedMergeCount = this.mergeCount = -1;
        this.key = key;
        this.keyBytes = keyBytes;
        this.status = OperationStatus.SENDING;
        this.latch = latch;
        this.commandType = cmdType;
    }

    public Command(CommandType cmdType) {
        this.copiedMergeCount = this.mergeCount = -1;
        this.commandType = cmdType;
        this.status = OperationStatus.SENDING;
    }

    public Command(CommandType cmdType, CountDownLatch latch) {
        this.copiedMergeCount = this.mergeCount = -1;
        this.commandType = cmdType;
        this.latch = latch;
        this.status = OperationStatus.SENDING;
    }

    public Command(String key, CommandType commandType, CountDownLatch latch) {
        this.copiedMergeCount = this.mergeCount = -1;
        this.key = key;
        this.commandType = commandType;
        this.latch = latch;
        this.status = OperationStatus.SENDING;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public final void setStatus(OperationStatus status) {
        this.status = status;
    }

    public final void setIoBuffer(IoBuffer ioBuffer) {
        this.ioBuffer = ioBuffer;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception throwable) {
        this.exception = throwable;
    }

    public final String getKey() {
        return this.key;
    }

    public final void setKey(String key) {
        this.key = key;
    }

    public final Object getResult() {
        return this.result;
    }

    public final void setResult(Object result) {
        this.result = result;
    }

    public final IoBuffer getIoBuffer() {
        return this.ioBuffer;
    }

    public String toString() {
        try {
            return new String(this.ioBuffer.buf().array(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "[error]";
        }
    }

    public boolean isCancel() {
        return this.status == OperationStatus.SENDING && this.cancel;
    }

    public final void cancel() {
        this.cancel = true;
        if (this.ioBuffer != null) {
            this.ioBuffer.free();
        }
    }

    public final CountDownLatch getLatch() {
        return this.latch;
    }

    public final void countDownLatch() {
        if (this.latch != null) {
            this.latch.countDown();
            if (this.latch.getCount() == 0L) {
                this.status = OperationStatus.DONE;
            }
        }
    }

    public final CommandType getCommandType() {
        return this.commandType;
    }

    public final void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public abstract void encode();

    public abstract boolean decode(MemcachedTCPSession var1, ByteBuffer var2);

    protected final void decodeError(String msg, Throwable e) {
        throw new MemcachedDecodeException(msg == null ? "decode error,session will be closed,key=" + this.key : msg, e);
    }

    protected final void decodeError() {
        throw new MemcachedDecodeException("decode error,session will be closed,key=" + this.key);
    }

    protected final boolean decodeError(String line) {
        if (line.startsWith("ERROR")) {
            String[] splits = line.split("ERROR");
            String errorMsg = splits.length >= 2 ? splits[1] : "Unknow command " + (Object)((Object)this.getCommandType());
            this.setException(new UnknownCommandException("Response error,error message:" + errorMsg + ",key=" + this.key));
            this.countDownLatch();
            return true;
        }
        if (line.startsWith("CLIENT_ERROR")) {
            this.setException(new MemcachedClientException(this.getErrorMsg(line, "Unknown Client Error")));
            this.countDownLatch();
            return true;
        }
        if (line.startsWith("SERVER_ERROR")) {
            this.setException(new MemcachedServerException(this.getErrorMsg(line, "Unknown Server Error")));
            this.countDownLatch();
            return true;
        }
        throw new MemcachedDecodeException("Decode error,session will be closed,key=" + this.key + ",server returns=" + line);
    }

    protected final boolean decodeError(Session session, ByteBuffer buffer) {
        String line = ByteUtils.nextLine(buffer);
        if (line == null) {
            return false;
        }
        return this.decodeError(line);
    }

    private String getErrorMsg(String line, String defaultMsg) {
        int index = line.indexOf(" ");
        String errorMsg = index > 0 ? line.substring(index + 1) : defaultMsg;
        errorMsg = errorMsg + ",key=" + this.key;
        return errorMsg;
    }

    public final boolean isNoreply() {
        return this.noreply;
    }

    public final void setNoreply(boolean noreply) {
        this.noreply = noreply;
    }

    @Override
    public FutureImpl<Boolean> getWriteFuture() {
        return this.writeFuture;
    }

    public final void setWriteFuture(FutureImpl<Boolean> writeFuture) {
        this.writeFuture = writeFuture;
    }

    @Override
    public final boolean isWriting() {
        return true;
    }

    @Override
    public final void writing() {
    }
}

