/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.WriteMessage;
import com.google.code.yanf4j.core.impl.FutureImpl;
import com.google.code.yanf4j.nio.NioSessionConfig;
import com.google.code.yanf4j.nio.impl.NioTCPSession;
import com.google.code.yanf4j.util.LinkedTransferQueue;
import com.google.code.yanf4j.util.SystemUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedOptimizer;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.OperationStatus;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.networking.MemcachedSession;
import net.rubyeye.xmemcached.utils.InetSocketAddressWrapper;
import net.rubyeye.xmemcached.utils.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedTCPSession
extends NioTCPSession
implements MemcachedSession {
    protected BlockingQueue<Command> commandAlreadySent;
    private final AtomicReference<Command> currentCommand = new LinkedTransferQueue.PaddedAtomicReference<Object>(null);
    private SocketAddress remoteSocketAddress;
    private int sendBufferSize;
    private final MemcachedOptimizer optimiezer;
    private boolean allowReconnect;
    private volatile boolean authFailed;
    private final CommandFactory commandFactory;
    private InetSocketAddressWrapper inetSocketAddressWrapper;
    private BufferAllocator bufferAllocator;

    public MemcachedTCPSession(NioSessionConfig sessionConfig, int readRecvBufferSize, MemcachedOptimizer optimiezer, int readThreadCount, CommandFactory commandFactory) {
        super(sessionConfig, readRecvBufferSize);
        this.optimiezer = optimiezer;
        if (this.selectableChannel != null) {
            this.remoteSocketAddress = ((SocketChannel)this.selectableChannel).socket().getRemoteSocketAddress();
            this.allowReconnect = true;
            try {
                this.sendBufferSize = ((SocketChannel)this.selectableChannel).socket().getSendBufferSize();
            }
            catch (SocketException e) {
                this.sendBufferSize = 8192;
            }
        }
        this.commandAlreadySent = (BlockingQueue)SystemUtils.createTransferQueue();
        this.commandFactory = commandFactory;
    }

    @Override
    public InetSocketAddressWrapper getInetSocketAddressWrapper() {
        return this.inetSocketAddressWrapper;
    }

    @Override
    public int getOrder() {
        return this.getInetSocketAddressWrapper().getOrder();
    }

    @Override
    public int getWeight() {
        return this.getInetSocketAddressWrapper().getWeight();
    }

    public void setInetSocketAddressWrapper(InetSocketAddressWrapper inetSocketAddressWrapper) {
        this.inetSocketAddressWrapper = inetSocketAddressWrapper;
    }

    public String toString() {
        return SystemUtils.getRawAddress(this.getRemoteSocketAddress()) + ":" + this.getRemoteSocketAddress().getPort();
    }

    @Override
    public void destroy() {
        CountDownLatch latch;
        Command command = this.currentCommand.get();
        if (command != null) {
            command.setException(new MemcachedException("Session has been closed"));
            latch = command.getLatch();
            if (latch != null) {
                latch.countDown();
            }
        }
        while ((command = (Command)this.commandAlreadySent.poll()) != null) {
            command.setException(new MemcachedException("Session has been closed"));
            latch = command.getLatch();
            if (latch == null) continue;
            latch.countDown();
        }
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        InetSocketAddress result = super.getRemoteSocketAddress();
        if (result == null && this.remoteSocketAddress != null) {
            result = (InetSocketAddress)this.remoteSocketAddress;
        }
        return result;
    }

    @Override
    protected WriteMessage preprocessWriteMessage(WriteMessage writeMessage) {
        Command currentCommand = (Command)writeMessage;
        if (currentCommand.getIoBuffer() == null) {
            currentCommand.encode();
        }
        if (currentCommand.getStatus() == OperationStatus.SENDING) {
            currentCommand = this.optimiezer.optimize(currentCommand, this.writeQueue, this.commandAlreadySent, this.sendBufferSize);
        }
        currentCommand.setStatus(OperationStatus.WRITING);
        if (!(currentCommand.isAdded() || currentCommand.isNoreply() && this.commandFactory.getProtocol() != Protocol.Binary)) {
            currentCommand.setAdded(true);
            this.addCommand(currentCommand);
        }
        return currentCommand;
    }

    @Override
    public boolean isAuthFailed() {
        return this.authFailed;
    }

    @Override
    public void setAuthFailed(boolean authFailed) {
        this.authFailed = authFailed;
    }

    public final BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    @Override
    public final void setBufferAllocator(BufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
    }

    @Override
    protected final WriteMessage wrapMessage(Object msg, Future<Boolean> writeFuture) {
        ((Command)msg).encode();
        ((Command)msg).setWriteFuture((FutureImpl)writeFuture);
        if (log.isDebugEnabled()) {
            log.debug("After encoding" + ((Command)msg).toString());
        }
        return (WriteMessage)msg;
    }

    private Command takeExecutingCommand() {
        try {
            return this.commandAlreadySent.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public boolean isAllowReconnect() {
        return this.allowReconnect;
    }

    @Override
    public void setAllowReconnect(boolean reconnected) {
        this.allowReconnect = reconnected;
    }

    public void addCommand(Command command) {
        this.commandAlreadySent.add(command);
    }

    public void setCurrentCommand(Command cmd) {
        this.currentCommand.set(cmd);
    }

    public Command getCurrentCommand() {
        return this.currentCommand.get();
    }

    public void takeCurrentCommand() {
        this.setCurrentCommand(this.takeExecutingCommand());
    }

    @Override
    public void quit() {
        this.write(this.commandFactory.createQuitCommand());
    }
}

