/**
 * Copyright [2009-2010] [dennis zhuang(killme2008@gmail.com)] Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance with the License. You
 * may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations under the License
 */
/**
 * Copyright [2009-2010] [dennis zhuang(killme2008@gmail.com)] Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance with the License. You
 * may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations under the License
 */
package net.rubyeye.xmemcached.command.kestrel;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.text.TextFlushAllCommand;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.utils.ByteUtils;

/**
 * Kestrel flush command
 * 
 * @author dennis
 * 
 */
public class KestrelFlushAllCommand extends TextFlushAllCommand {

  public KestrelFlushAllCommand(CountDownLatch latch, int delay, boolean noreply) {
    super(latch, delay, noreply);
  }

  @Override
  public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
    if (buffer == null || !buffer.hasRemaining()) {
      return false;
    }
    String line = ByteUtils.nextLine(buffer);
    if (line == null) {
      return false;
    } else {
      if (line.startsWith("Flushed")) {
        setResult(Boolean.TRUE);
        countDownLatch();
        return true;
      } else {
        return decodeError(session, buffer);
      }
    }
  }

}
