/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedTransferQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private static final int NOWAIT = 0;
    private static final int TIMEOUT = 1;
    private static final int WAIT = 2;
    private static final int NCPUS = Runtime.getRuntime().availableProcessors();
    private static final int maxTimedSpins = NCPUS < 2 ? 0 : 32;
    private static final int maxUntimedSpins = maxTimedSpins * 16;
    private static final long spinForTimeoutThreshold = 1000L;
    private final PaddedAtomicReference<QNode> head;
    private final PaddedAtomicReference<QNode> tail;
    private final PaddedAtomicReference<QNode> cleanMe;

    private boolean advanceHead(QNode h, QNode nh) {
        if (h == this.head.get() && this.head.compareAndSet(h, nh)) {
            h.next = h;
            return true;
        }
        return false;
    }

    private Object xfer(Object e, int mode, long nanos) {
        Object x;
        QNode first;
        boolean isData = e != null;
        QNode s = null;
        PaddedAtomicReference<QNode> head = this.head;
        PaddedAtomicReference<QNode> tail = this.tail;
        while (true) {
            QNode t = (QNode)tail.get();
            QNode h = (QNode)head.get();
            if (t != null && (t == h || t.isData == isData)) {
                QNode last;
                if (s == null) {
                    s = new QNode(e, isData);
                }
                if ((last = t.next) != null) {
                    if (t != tail.get()) continue;
                    tail.compareAndSet(t, last);
                    continue;
                }
                if (!t.casNext(null, s)) continue;
                tail.compareAndSet(t, s);
                return this.awaitFulfill(t, s, e, mode, nanos);
            }
            if (h == null) continue;
            first = h.next;
            if (t == tail.get() && first != null && this.advanceHead(h, first) && (x = first.get()) != first && first.compareAndSet(x, e)) break;
        }
        LockSupport.unpark(first.waiter);
        return isData ? e : x;
    }

    private Object fulfill(Object e) {
        Object x;
        QNode first;
        boolean isData = e != null;
        PaddedAtomicReference<QNode> head = this.head;
        PaddedAtomicReference<QNode> tail = this.tail;
        while (true) {
            QNode t = (QNode)tail.get();
            QNode h = (QNode)head.get();
            if (t != null && (t == h || t.isData == isData)) {
                QNode last = t.next;
                if (t != tail.get()) continue;
                if (last != null) {
                    tail.compareAndSet(t, last);
                    continue;
                }
                return null;
            }
            if (h == null) continue;
            first = h.next;
            if (t == tail.get() && first != null && this.advanceHead(h, first) && (x = first.get()) != first && first.compareAndSet(x, e)) break;
        }
        LockSupport.unpark(first.waiter);
        return isData ? e : x;
    }

    private Object awaitFulfill(QNode pred, QNode s, Object e, int mode, long nanos) {
        if (mode == 0) {
            return null;
        }
        long lastTime = mode == 1 ? System.nanoTime() : 0L;
        Thread w = Thread.currentThread();
        int spins = -1;
        while (true) {
            long now;
            Object x;
            if (w.isInterrupted()) {
                s.compareAndSet(e, s);
            }
            if ((x = s.get()) != e) {
                this.advanceHead(pred, s);
                if (x == s) {
                    this.clean(pred, s);
                    return null;
                }
                if (x != null) {
                    s.set(s);
                    return x;
                }
                return e;
            }
            if (mode == 1 && (nanos -= (now = System.nanoTime()) - (lastTime = now)) <= 0L) {
                s.compareAndSet(e, s);
                continue;
            }
            if (spins < 0) {
                QNode h = (QNode)this.head.get();
                int n = h != null && h.next == s ? (mode == 1 ? maxTimedSpins : maxUntimedSpins) : (spins = 0);
            }
            if (spins > 0) {
                --spins;
                continue;
            }
            if (s.waiter == null) {
                s.waiter = w;
                continue;
            }
            if (mode != 1) {
                LockSupport.park();
                s.waiter = null;
                spins = -1;
                continue;
            }
            if (nanos <= 1000L) continue;
            LockSupport.parkNanos(nanos);
            s.waiter = null;
            spins = -1;
        }
    }

    private QNode getValidatedTail() {
        QNode t;
        while (true) {
            QNode h = (QNode)this.head.get();
            QNode first = h.next;
            if (first != null && first.next == first) {
                this.advanceHead(h, first);
                continue;
            }
            t = (QNode)this.tail.get();
            QNode last = t.next;
            if (t != this.tail.get()) continue;
            if (last == null) break;
            this.tail.compareAndSet(t, last);
        }
        return t;
    }

    void clean(QNode pred, QNode s) {
        Thread w = s.waiter;
        if (w != null) {
            s.waiter = null;
            if (w != Thread.currentThread()) {
                LockSupport.unpark(w);
            }
        }
        while (pred.next == s) {
            QNode sn;
            QNode oldpred = this.reclean();
            QNode t = this.getValidatedTail();
            if (!(s != t ? (sn = s.next) == s || pred.casNext(s, sn) : oldpred == pred || oldpred == null && this.cleanMe.compareAndSet(null, pred))) continue;
            break;
        }
    }

    private QNode reclean() {
        QNode t;
        QNode s;
        QNode pred;
        while ((pred = (QNode)this.cleanMe.get()) != null && (s = pred.next) != (t = this.getValidatedTail())) {
            QNode sn;
            if (s != null && s != pred && s.get() == s && (sn = s.next) != s && !pred.casNext(s, sn)) continue;
            this.cleanMe.compareAndSet(pred, null);
        }
        return pred;
    }

    E cast(Object e) {
        return (E)e;
    }

    public LinkedTransferQueue() {
        QNode dummy = new QNode(null, false);
        this.head = new PaddedAtomicReference<QNode>(dummy);
        this.tail = new PaddedAtomicReference<QNode>(dummy);
        this.cleanMe = new PaddedAtomicReference<Object>(null);
    }

    public LinkedTransferQueue(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.xfer(e, 0, 0L);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    public void transfer(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.xfer(e, 2, 0L) == null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    public boolean tryTransfer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.xfer(e, 1, unit.toNanos(timeout)) != null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    public boolean tryTransfer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.fulfill(e) != null;
    }

    @Override
    public E take() throws InterruptedException {
        Object e = this.xfer(null, 2, 0L);
        if (e != null) {
            return this.cast(e);
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object e = this.xfer(null, 1, unit.toNanos(timeout));
        if (e != null || !Thread.interrupted()) {
            return this.cast(e);
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return this.cast(this.fulfill(null));
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E e;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E e;
        int n;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < maxElements && (e = this.poll()) != null; ++n) {
            c.add(e);
        }
        return n;
    }

    QNode traversalHead() {
        QNode h;
        block2: {
            while (true) {
                QNode t = (QNode)this.tail.get();
                h = (QNode)this.head.get();
                if (h == null || t == null) continue;
                QNode last = t.next;
                QNode first = h.next;
                if (t != this.tail.get()) continue;
                if (last != null) {
                    this.tail.compareAndSet(t, last);
                    continue;
                }
                if (first == null) break block2;
                Object x = first.get();
                if (x != first) break;
                this.advanceHead(h, first);
            }
            return h;
        }
        return h;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E peek() {
        Object x;
        while (true) {
            QNode h = this.traversalHead();
            QNode p = h.next;
            if (p == null) {
                return null;
            }
            x = p.get();
            if (p == x) continue;
            if (!p.isData) {
                return null;
            }
            if (x != null) break;
        }
        return this.cast(x);
    }

    @Override
    public boolean isEmpty() {
        while (true) {
            QNode h = this.traversalHead();
            QNode p = h.next;
            if (p == null) {
                return true;
            }
            Object x = p.get();
            if (p == x) continue;
            if (!p.isData) {
                return true;
            }
            if (x != null) break;
        }
        return false;
    }

    public boolean hasWaitingConsumer() {
        Object x;
        QNode p;
        do {
            QNode h = this.traversalHead();
            p = h.next;
            if (p != null) continue;
            return false;
        } while (p == (x = p.get()));
        return !p.isData;
    }

    @Override
    public int size() {
        Object x;
        int count = 0;
        QNode h = this.traversalHead();
        QNode p = h.next;
        while (p != null && p.isData && ((x = p.get()) == null || x == p || ++count != Integer.MAX_VALUE)) {
            p = p.next;
        }
        return count;
    }

    public int getWaitingConsumerCount() {
        int count = 0;
        QNode h = this.traversalHead();
        QNode p = h.next;
        while (!(p == null || p.isData || p.get() == null && ++count == Integer.MAX_VALUE)) {
            p = p.next;
        }
        return count;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Itr
    implements Iterator<E> {
        QNode nextNode;
        QNode currentNode;
        QNode prevNode;
        E nextItem;

        Itr() {
            this.nextNode = LinkedTransferQueue.this.traversalHead();
            this.advance();
        }

        E advance() {
            this.prevNode = this.currentNode;
            this.currentNode = this.nextNode;
            Object x = this.nextItem;
            QNode p = this.nextNode.next;
            while (true) {
                if (p == null || !p.isData) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return x;
                }
                Object item = p.get();
                if (item != p && item != null) {
                    this.nextNode = p;
                    this.nextItem = LinkedTransferQueue.this.cast(item);
                    return x;
                }
                this.prevNode = p;
                p = p.next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            QNode p = this.currentNode;
            QNode prev = this.prevNode;
            if (prev == null || p == null) {
                throw new IllegalStateException();
            }
            Object x = p.get();
            if (x != null && x != p && p.compareAndSet(x, p)) {
                LinkedTransferQueue.this.clean(prev, p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PaddedAtomicReference<T>
    extends AtomicReference<T> {
        private static final long serialVersionUID = 4684288940772921317L;
        public Object p0;
        public Object p1;
        public Object p2;
        public Object p3;
        public Object p4;
        public Object p5;
        public Object p6;
        public Object p7;
        public Object p8;
        public Object p9;
        public Object pa;
        public Object pb;
        public Object pc;
        public Object pd;
        public Object pe;

        public PaddedAtomicReference(T r) {
            super(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QNode
    extends AtomicReference<Object> {
        private static final long serialVersionUID = 5925596372370723938L;
        volatile transient QNode next;
        volatile transient Thread waiter;
        final boolean isData;
        public long p1;
        public long p2;
        public long p3;
        public long p4;
        public long p5;
        public long p6;
        public long p7;
        private static final AtomicReferenceFieldUpdater<QNode, QNode> nextUpdater;

        QNode(Object item, boolean isData) {
            super(item);
            this.isData = isData;
        }

        boolean casNext(QNode cmp, QNode val) {
            if (nextUpdater != null) {
                return nextUpdater.compareAndSet(this, cmp, val);
            }
            return this.alternativeCasNext(cmp, val);
        }

        private synchronized boolean alternativeCasNext(QNode cmp, QNode val) {
            if (this.next == cmp) {
                this.next = val;
                return true;
            }
            return false;
        }

        static {
            AtomicReferenceFieldUpdater<QNode, QNode> tmp = null;
            try {
                tmp = AtomicReferenceFieldUpdater.newUpdater(QNode.class, QNode.class, "next");
                QNode testNode = new QNode(null, false);
                tmp.set(testNode, testNode);
                if (testNode.next != testNode) {
                    throw new Exception();
                }
            }
            catch (Throwable t) {
                tmp = null;
            }
            nextUpdater = tmp;
        }
    }
}

