/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.aws;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.aws.AWSElasticCacheClient;
import net.rubyeye.xmemcached.utils.AddrUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSElasticCacheClientBuilder
extends XMemcachedClientBuilder {
    private List<InetSocketAddress> configAddrs;
    private long pollConfigIntervalMs = 60000L;

    public long getPollConfigIntervalMs() {
        return this.pollConfigIntervalMs;
    }

    public void setPollConfigIntervalMs(long pollConfigIntervalMs) {
        this.pollConfigIntervalMs = pollConfigIntervalMs;
    }

    public List<InetSocketAddress> getConfigAddrs() {
        return this.configAddrs;
    }

    public void setConfigAddrs(List<InetSocketAddress> configAddrs) {
        this.configAddrs = configAddrs;
    }

    public AWSElasticCacheClientBuilder(String serverList) {
        this(AddrUtil.getAddresses(serverList));
    }

    public AWSElasticCacheClientBuilder(InetSocketAddress addr) {
        this(AWSElasticCacheClientBuilder.asList(addr));
    }

    private static List<InetSocketAddress> asList(InetSocketAddress addr) {
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        ret.add(addr);
        return ret;
    }

    public AWSElasticCacheClientBuilder(List<InetSocketAddress> configAddrs) {
        super(configAddrs);
        this.configAddrs = configAddrs;
    }

    @Override
    public AWSElasticCacheClient build() throws IOException {
        AWSElasticCacheClient memcachedClient = new AWSElasticCacheClient(this.sessionLocator, this.sessionComparator, this.bufferAllocator, this.configuration, this.socketOptions, this.commandFactory, this.transcoder, this.stateListeners, this.authInfoMap, this.connectionPoolSize, this.connectTimeout, this.name, this.failureMode, this.resolveInetAddresses, this.configAddrs, this.pollConfigIntervalMs);
        this.configureClient(memcachedClient);
        return memcachedClient;
    }
}

