/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils;

import java.net.InetSocketAddress;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class InetSocketAddressWrapper {
    private volatile InetSocketAddress inetSocketAddress;
    private int order;
    private int weight;
    private volatile String remoteAddressStr;
    private volatile String hostName;
    private volatile String mainNodeHostName;
    private boolean resolve;
    private volatile InetSocketAddress mainNodeAddress;

    public InetSocketAddressWrapper(InetSocketAddress inetSocketAddress, int order, int weight, InetSocketAddress mainNodeAddress) {
        this(inetSocketAddress, order, weight, mainNodeAddress, true);
    }

    public InetSocketAddressWrapper(InetSocketAddress inetSocketAddress, int order, int weight, InetSocketAddress mainNodeAddress, boolean resolve) {
        this.resolve = resolve;
        this.setInetSocketAddress(inetSocketAddress);
        this.setMainNodeAddress(mainNodeAddress);
        this.order = order;
        this.weight = weight;
    }

    public String getRemoteAddressStr() {
        return this.remoteAddressStr;
    }

    public void setRemoteAddressStr(String remoteAddressStr) {
        this.remoteAddressStr = remoteAddressStr;
    }

    public final InetSocketAddress getInetSocketAddress() {
        if (this.resolve && ByteUtils.isValidString(this.hostName)) {
            return new InetSocketAddress(this.hostName, this.inetSocketAddress.getPort());
        }
        return this.inetSocketAddress;
    }

    public final InetSocketAddress getResolvedSocketAddress() {
        return this.inetSocketAddress;
    }

    public final void setResolvedSocketAddress(InetSocketAddress addr) {
        this.inetSocketAddress = addr;
    }

    public final InetSocketAddress getResolvedMainNodeSocketAddress() {
        return this.mainNodeAddress;
    }

    public final void setResolvedMainNodeSocketAddress(InetSocketAddress addr) {
        this.mainNodeAddress = addr;
    }

    private final void setInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
        if (this.resolve && inetSocketAddress != null) {
            this.hostName = inetSocketAddress.getHostName();
        }
    }

    public final int getOrder() {
        return this.order;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public InetSocketAddress getMainNodeAddress() {
        if (this.resolve && ByteUtils.isValidString(this.mainNodeHostName)) {
            return new InetSocketAddress(this.mainNodeHostName, this.mainNodeAddress.getPort());
        }
        return this.mainNodeAddress;
    }

    private void setMainNodeAddress(InetSocketAddress mainNodeAddress) {
        this.mainNodeAddress = mainNodeAddress;
        if (this.resolve && mainNodeAddress != null) {
            this.mainNodeHostName = mainNodeAddress.getHostName();
        }
    }

    public final void setOrder(int order) {
        this.order = order;
    }
}

