/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.common.configuration;

import com.gradle.maven.common.configuration.MavenTemplateEvaluationContext;
import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary.Hex;
import com.gradle.nullability.Nullable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;

public interface SpringTemplateEvaluationContext
extends MavenTemplateEvaluationContext {
    @Nullable
    public MavenProject getPom();

    public Map<String, String> getEnv();

    @Nullable
    public String getUsername();

    @Nullable
    public List<String> getIpAddresses();

    default public boolean isFalse(@Nullable Object value) {
        String stringValue = String.valueOf(value);
        return Stream.of("false", "0", "0.0", "null").anyMatch(it -> it.equalsIgnoreCase(stringValue));
    }

    default public boolean isTrue(@Nullable Object value) {
        return !this.isFalse(value);
    }

    @Nullable
    default public Object sha512(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(this::sha512).collect(Collectors.toList());
        }
        String stringValue = value.toString();
        try {
            byte[] digest = MessageDigest.getInstance("SHA-512").digest(stringValue.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString(digest);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
    }
}

