/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.minlog;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Log {
    private static int level = 3;
    public static boolean ERROR = level <= 5;
    public static boolean WARN = level <= 4;
    public static boolean INFO = level <= 3;
    public static boolean DEBUG = level <= 2;
    public static boolean TRACE = level <= 1;
    private static Logger logger = new Logger();

    public static void warn(String message) {
        if (WARN) {
            logger.log(4, null, message, null);
        }
    }

    public static void debug(String category, String message, Throwable ex) {
        if (DEBUG) {
            logger.log(2, category, message, ex);
        }
    }

    public static void debug(String category, String message) {
        if (DEBUG) {
            logger.log(2, category, message, null);
        }
    }

    public static void trace(String category, String message, Throwable ex) {
        if (TRACE) {
            logger.log(1, category, message, ex);
        }
    }

    public static void trace(String category, String message) {
        if (TRACE) {
            logger.log(1, category, message, null);
        }
    }

    public static class Logger {
        private final long firstLogTime = System.currentTimeMillis();

        public void log(int level, String category, String message, Throwable ex) {
            StringBuilder builder = new StringBuilder(256);
            long time = System.currentTimeMillis() - this.firstLogTime;
            long minutes = time / 60000L;
            long seconds = time / 1000L % 60L;
            if (minutes <= 9L) {
                builder.append('0');
            }
            builder.append(minutes);
            builder.append(':');
            if (seconds <= 9L) {
                builder.append('0');
            }
            builder.append(seconds);
            switch (level) {
                case 5: {
                    builder.append(" ERROR: ");
                    break;
                }
                case 4: {
                    builder.append("  WARN: ");
                    break;
                }
                case 3: {
                    builder.append("  INFO: ");
                    break;
                }
                case 2: {
                    builder.append(" DEBUG: ");
                    break;
                }
                case 1: {
                    builder.append(" TRACE: ");
                }
            }
            if (category != null) {
                builder.append('[');
                builder.append(category);
                builder.append("] ");
            }
            builder.append(message);
            if (ex != null) {
                StringWriter writer = new StringWriter(256);
                ex.printStackTrace(new PrintWriter(writer));
                builder.append('\n');
                builder.append(writer.toString().trim());
            }
            this.print(builder.toString());
        }

        protected void print(String message) {
            System.out.println(message);
        }
    }
}

