/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.KryoException;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Registration;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.InputChunked;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.Output;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.OutputChunked;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.IntMap;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private FieldSerializer.CachedField[] writeTags;
    private IntMap<FieldSerializer.CachedField> readTags;
    private final TaggedFieldSerializerConfig config;

    public TaggedFieldSerializer(Kryo kryo, Class type, TaggedFieldSerializerConfig config) {
        super(kryo, type, config);
        this.config = config;
        this.setAcceptsNull(true);
    }

    @Override
    protected void initializeCachedFields() {
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        int n2 = fields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = fields[i2].field;
            if (field.getAnnotation(Tag.class) != null) continue;
            if (Log.TRACE) {
                Log.trace("kryo", "Ignoring field without tag: " + fields[i2]);
            }
            super.removeField(fields[i2]);
        }
        fields = this.cachedFields.fields;
        ArrayList<FieldSerializer.CachedField> writeTags = new ArrayList<FieldSerializer.CachedField>(fields.length);
        this.readTags = new IntMap((int)((float)fields.length / 0.8f));
        for (FieldSerializer.CachedField cachedField : fields) {
            Field field = cachedField.field;
            int tag = field.getAnnotation(Tag.class).value();
            if (this.readTags.containsKey(tag)) {
                throw new KryoException(String.format("Duplicate tag %d on fields: %s and %s", tag, field, writeTags.get(tag)));
            }
            this.readTags.put(tag, cachedField);
            if (field.getAnnotation(Deprecated.class) == null) {
                writeTags.add(cachedField);
            }
            cachedField.tag = tag;
        }
        this.writeTags = writeTags.toArray(new FieldSerializer.CachedField[writeTags.size()]);
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field) {
        super.removeField(field);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        Output fieldOutput;
        if (object == null) {
            output.writeByte((byte)0);
            return;
        }
        int pop = this.pushTypeVariables();
        FieldSerializer.CachedField[] writeTags = this.writeTags;
        output.writeVarInt(writeTags.length + 1, true);
        this.writeHeader(kryo, output, object);
        boolean chunked = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownTagData;
        OutputChunked outputChunked = null;
        if (chunked) {
            outputChunked = new OutputChunked(output, this.config.chunkSize);
            fieldOutput = outputChunked;
        } else {
            fieldOutput = output;
        }
        for (FieldSerializer.CachedField cachedField : writeTags) {
            if (Log.TRACE) {
                this.log("Write", cachedField, output.position());
            }
            output.writeVarInt(cachedField.tag, true);
            if (readUnknownTagData) {
                Class<?> valueClass = null;
                try {
                    Object value;
                    if (object != null && (value = cachedField.field.get(object)) != null) {
                        valueClass = value.getClass();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                kryo.writeClass(fieldOutput, valueClass);
                if (valueClass == null) {
                    if (!chunked) continue;
                    outputChunked.endChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
                cachedField.setReuseSerializer(false);
            }
            cachedField.write(fieldOutput, object);
            if (!chunked) continue;
            outputChunked.endChunk();
        }
        this.popTypeVariables(pop);
    }

    protected void writeHeader(Kryo kryo, Output output, T object) {
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        Input fieldInput;
        int fieldCount = input.readVarInt(true);
        if (fieldCount == 0) {
            return null;
        }
        --fieldCount;
        int pop = this.pushTypeVariables();
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        boolean chunked = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownTagData;
        InputChunked inputChunked = null;
        if (chunked) {
            inputChunked = new InputChunked(input, this.config.chunkSize);
            fieldInput = inputChunked;
        } else {
            fieldInput = input;
        }
        IntMap<FieldSerializer.CachedField> readTags = this.readTags;
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            int tag = input.readVarInt(true);
            FieldSerializer.CachedField cachedField = readTags.get(tag);
            if (readUnknownTagData) {
                Registration registration;
                try {
                    registration = kryo.readClass(fieldInput);
                }
                catch (KryoException ex) {
                    String message = "Unable to read unknown tag " + tag + " data (unknown type). (" + this.getType().getName() + "#" + cachedField + ")";
                    if (!chunked) {
                        throw new KryoException(message, ex);
                    }
                    if (Log.DEBUG) {
                        Log.debug("kryo", message, ex);
                    }
                    inputChunked.nextChunk();
                    continue;
                }
                if (registration == null) {
                    if (!chunked) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                Class valueClass = registration.getType();
                if (cachedField == null) {
                    block20: {
                        if (Log.TRACE) {
                            Log.trace("kryo", "Read unknown tag " + tag + " data, type: " + Util.className(valueClass));
                        }
                        try {
                            kryo.readObject(fieldInput, valueClass);
                        }
                        catch (KryoException ex) {
                            String message = "Unable to read unknown tag " + tag + " data, type: " + Util.className(valueClass) + " (" + this.getType().getName() + "#" + cachedField + ")";
                            if (!chunked) {
                                throw new KryoException(message, ex);
                            }
                            if (!Log.DEBUG) break block20;
                            Log.debug("kryo", message, ex);
                        }
                    }
                    if (!chunked) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
                cachedField.setReuseSerializer(false);
            } else if (cachedField == null) {
                if (!chunked) {
                    throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
                }
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip unknown field tag: " + tag);
                }
                inputChunked.nextChunk();
                continue;
            }
            if (Log.TRACE) {
                this.log("Read", cachedField, input.position());
            }
            cachedField.read(fieldInput, object);
            if (!chunked) continue;
            inputChunked.nextChunk();
        }
        this.popTypeVariables(pop);
        return object;
    }

    public static class TaggedFieldSerializerConfig
    extends FieldSerializer.FieldSerializerConfig {
        boolean readUnknownTagData;
        boolean chunked;
        int chunkSize = 1024;

        @Override
        public TaggedFieldSerializerConfig clone() {
            return (TaggedFieldSerializerConfig)super.clone();
        }

        public void setReadUnknownTagData(boolean readUnknownTagData) {
            this.readUnknownTagData = readUnknownTagData;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

