/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.ReferenceResolver;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.IdentityObjectIntMap;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.Util;
import java.util.ArrayList;

public class MapReferenceResolver
implements ReferenceResolver {
    protected Kryo kryo;
    protected final IdentityObjectIntMap<Object> writtenObjects = new IdentityObjectIntMap();
    protected final ArrayList<Object> readObjects = new ArrayList();
    private final int maximumCapacity;

    public MapReferenceResolver() {
        this(2048);
    }

    public MapReferenceResolver(int maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    @Override
    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    @Override
    public int addWrittenObject(Object object) {
        int id = this.writtenObjects.size;
        this.writtenObjects.put(object, id);
        return id;
    }

    @Override
    public int getWrittenId(Object object) {
        return this.writtenObjects.get(object, -1);
    }

    @Override
    public int nextReadId(Class type) {
        int id = this.readObjects.size();
        this.readObjects.add(null);
        return id;
    }

    @Override
    public void setReadObject(int id, Object object) {
        this.readObjects.set(id, object);
    }

    @Override
    public Object getReadObject(Class type, int id) {
        return this.readObjects.get(id);
    }

    @Override
    public void reset() {
        int size = this.readObjects.size();
        this.readObjects.clear();
        if (size > this.maximumCapacity) {
            this.readObjects.trimToSize();
            this.readObjects.ensureCapacity(this.maximumCapacity);
        }
        this.writtenObjects.clear(this.maximumCapacity);
    }

    @Override
    public boolean useReferences(Class type) {
        return !Util.isWrapperClass(type) && !Util.isEnum(type);
    }
}

