/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BeanUtil {
    public static Object getDefaultValue(JavaType type) {
        Class<?> cls = type.getRawClass();
        Class<?> prim = ClassUtil.primitiveType(cls);
        if (prim != null) {
            return ClassUtil.defaultValue(prim);
        }
        if (type.isContainerType() || type.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (cls == String.class) {
            return "";
        }
        if (type.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (type.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar c2 = new GregorianCalendar();
            c2.setTimeInMillis(0L);
            return c2;
        }
        return null;
    }

    public static String checkUnsupportedType(JavaType type) {
        String moduleName;
        String typeName;
        String className = type.getRawClass().getName();
        if (BeanUtil.isJava8TimeClass(className)) {
            if (className.indexOf(46, 10) >= 0) {
                return null;
            }
            typeName = "Java 8 date/time";
            moduleName = "com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype:jackson-datatype-jsr310";
        } else if (BeanUtil.isJodaTimeClass(className)) {
            typeName = "Joda date/time";
            moduleName = "com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype:jackson-datatype-joda";
        } else {
            return null;
        }
        return String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", typeName, ClassUtil.getTypeDescription(type), moduleName);
    }

    private static boolean isJava8TimeClass(String className) {
        return className.startsWith("java.time.");
    }

    private static boolean isJodaTimeClass(String className) {
        return className.startsWith("org.joda.time.");
    }
}

