/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Predicate;
import java.util.Arrays;

public abstract class CharMatcher
implements Predicate<Character> {
    public static CharMatcher any() {
        return Any.INSTANCE;
    }

    public static CharMatcher none() {
        return None.INSTANCE;
    }

    public static CharMatcher whitespace() {
        return Whitespace.INSTANCE;
    }

    public static CharMatcher is(char match) {
        return new Is(match);
    }

    public static CharMatcher isNot(char match) {
        return new IsNot(match);
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return CharMatcher.none();
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                return CharMatcher.isEither(sequence.charAt(0), sequence.charAt(1));
            }
        }
        return new AnyOf(sequence);
    }

    public static CharMatcher inRange(char startInclusive, char endInclusive) {
        return new InRange(startInclusive, endInclusive);
    }

    protected CharMatcher() {
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new Negated(this);
    }

    public CharMatcher or(CharMatcher other) {
        return new Or(this, other);
    }

    public int indexIn(CharSequence sequence) {
        return this.indexIn(sequence, 0);
    }

    public int indexIn(CharSequence sequence, int start) {
        int length = sequence.length();
        Preconditions.checkPositionIndex(start, length);
        for (int i2 = start; i2 < length; ++i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int countIn(CharSequence sequence) {
        int count = 0;
        for (int i2 = 0; i2 < sequence.length(); ++i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            ++count;
        }
        return count;
    }

    public String replaceFrom(CharSequence sequence, char replacement) {
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[pos] = replacement;
        for (int i2 = pos + 1; i2 < chars.length; ++i2) {
            if (!this.matches(chars[i2])) continue;
            chars[i2] = replacement;
        }
        return new String(chars);
    }

    @Override
    @Deprecated
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    public String toString() {
        return super.toString();
    }

    private static String showCharacter(char c2) {
        String hex = "0123456789ABCDEF";
        char[] tmp = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i2 = 0; i2 < 4; ++i2) {
            tmp[5 - i2] = hex.charAt(c2 & 0xF);
            c2 = (char)(c2 >> 4);
        }
        return String.copyValueOf(tmp);
    }

    private static IsEither isEither(char c1, char c2) {
        return new IsEither(c1, c2);
    }

    private static final class InRange
    extends FastMatcher {
        private final char startInclusive;
        private final char endInclusive;

        InRange(char startInclusive, char endInclusive) {
            Preconditions.checkArgument(endInclusive >= startInclusive);
            this.startInclusive = startInclusive;
            this.endInclusive = endInclusive;
        }

        @Override
        public boolean matches(char c2) {
            return this.startInclusive <= c2 && c2 <= this.endInclusive;
        }

        @Override
        public String toString() {
            String string = CharMatcher.showCharacter(this.startInclusive);
            String string2 = CharMatcher.showCharacter(this.endInclusive);
            return new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CharMatcher.inRange('").append(string).append("', '").append(string2).append("')").toString();
        }
    }

    private static final class AnyOf
    extends CharMatcher {
        private final char[] chars;

        public AnyOf(CharSequence chars) {
            this.chars = chars.toString().toCharArray();
            Arrays.sort(this.chars);
        }

        @Override
        public boolean matches(char c2) {
            return Arrays.binarySearch(this.chars, c2) >= 0;
        }

        @Override
        public String toString() {
            StringBuilder description = new StringBuilder("CharMatcher.anyOf(\"");
            for (char c2 : this.chars) {
                description.append(CharMatcher.showCharacter(c2));
            }
            description.append("\")");
            return description.toString();
        }
    }

    private static final class IsEither
    extends FastMatcher {
        private final char match1;
        private final char match2;

        IsEither(char match1, char match2) {
            this.match1 = match1;
            this.match2 = match2;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.match1 || c2 == this.match2;
        }

        @Override
        public String toString() {
            String string = CharMatcher.showCharacter(this.match1);
            String string2 = CharMatcher.showCharacter(this.match2);
            return new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CharMatcher.anyOf(\"").append(string).append(string2).append("\")").toString();
        }
    }

    private static final class IsNot
    extends FastMatcher {
        private final char match;

        IsNot(char match) {
            this.match = match;
        }

        @Override
        public boolean matches(char c2) {
            return c2 != this.match;
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            return other.matches(this.match) ? IsNot.any() : this;
        }

        @Override
        public CharMatcher negate() {
            return IsNot.is(this.match);
        }

        @Override
        public String toString() {
            String string = CharMatcher.showCharacter(this.match);
            return new StringBuilder(21 + String.valueOf(string).length()).append("CharMatcher.isNot('").append(string).append("')").toString();
        }
    }

    private static final class Is
    extends FastMatcher {
        private final char match;

        Is(char match) {
            this.match = match;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.match;
        }

        @Override
        public String replaceFrom(CharSequence sequence, char replacement) {
            return sequence.toString().replace(this.match, replacement);
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            return other.matches(this.match) ? other : super.or(other);
        }

        @Override
        public CharMatcher negate() {
            return Is.isNot(this.match);
        }

        @Override
        public String toString() {
            String string = CharMatcher.showCharacter(this.match);
            return new StringBuilder(18 + String.valueOf(string).length()).append("CharMatcher.is('").append(string).append("')").toString();
        }
    }

    private static final class Or
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        Or(CharMatcher a2, CharMatcher b2) {
            this.first = Preconditions.checkNotNull(a2);
            this.second = Preconditions.checkNotNull(b2);
        }

        @Override
        public boolean matches(char c2) {
            return this.first.matches(c2) || this.second.matches(c2);
        }

        @Override
        public String toString() {
            String string = String.valueOf(this.first);
            String string2 = String.valueOf(this.second);
            return new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CharMatcher.or(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    private static class Negated
    extends CharMatcher {
        final CharMatcher original;

        Negated(CharMatcher original) {
            this.original = Preconditions.checkNotNull(original);
        }

        @Override
        public boolean matches(char c2) {
            return !this.original.matches(c2);
        }

        @Override
        public int countIn(CharSequence sequence) {
            return sequence.length() - this.original.countIn(sequence);
        }

        @Override
        public CharMatcher negate() {
            return this.original;
        }

        @Override
        public String toString() {
            String string = String.valueOf(this.original);
            return new StringBuilder(9 + String.valueOf(string).length()).append(string).append(".negate()").toString();
        }
    }

    static final class Whitespace
    extends NamedFastMatcher {
        static final int SHIFT = Integer.numberOfLeadingZeros("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length() - 1);
        static final Whitespace INSTANCE = new Whitespace();

        Whitespace() {
            super("CharMatcher.whitespace()");
        }

        @Override
        public boolean matches(char c2) {
            return "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charAt(1682554634 * c2 >>> SHIFT) == c2;
        }
    }

    private static final class None
    extends NamedFastMatcher {
        static final None INSTANCE = new None();

        private None() {
            super("CharMatcher.none()");
        }

        @Override
        public boolean matches(char c2) {
            return false;
        }

        @Override
        public int indexIn(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return -1;
        }

        @Override
        public int indexIn(CharSequence sequence, int start) {
            int length = sequence.length();
            Preconditions.checkPositionIndex(start, length);
            return -1;
        }

        @Override
        public String replaceFrom(CharSequence sequence, char replacement) {
            return sequence.toString();
        }

        @Override
        public int countIn(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return 0;
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            return Preconditions.checkNotNull(other);
        }

        @Override
        public CharMatcher negate() {
            return None.any();
        }
    }

    private static final class Any
    extends NamedFastMatcher {
        static final Any INSTANCE = new Any();

        private Any() {
            super("CharMatcher.any()");
        }

        @Override
        public boolean matches(char c2) {
            return true;
        }

        @Override
        public int indexIn(CharSequence sequence) {
            return sequence.length() == 0 ? -1 : 0;
        }

        @Override
        public int indexIn(CharSequence sequence, int start) {
            int length = sequence.length();
            Preconditions.checkPositionIndex(start, length);
            return start == length ? -1 : start;
        }

        @Override
        public String replaceFrom(CharSequence sequence, char replacement) {
            char[] array = new char[sequence.length()];
            Arrays.fill(array, replacement);
            return new String(array);
        }

        @Override
        public int countIn(CharSequence sequence) {
            return sequence.length();
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            Preconditions.checkNotNull(other);
            return this;
        }

        @Override
        public CharMatcher negate() {
            return Any.none();
        }
    }

    static class NegatedFastMatcher
    extends Negated {
        NegatedFastMatcher(CharMatcher original) {
            super(original);
        }
    }

    static abstract class NamedFastMatcher
    extends FastMatcher {
        private final String description;

        NamedFastMatcher(String description) {
            this.description = Preconditions.checkNotNull(description);
        }

        @Override
        public final String toString() {
            return this.description;
        }
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher() {
        }

        @Override
        public CharMatcher negate() {
            return new NegatedFastMatcher(this);
        }
    }
}

