/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotation;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.AbstractJavaModel;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultJavaAnnotation
extends AbstractJavaModel
implements JavaAnnotation,
AnnotationValue,
Serializable {
    private final JavaClass type;
    private final Map<String, AnnotationValue> properties = new LinkedHashMap<String, AnnotationValue>();
    private final Map<String, Object> namedParameters = new LinkedHashMap<String, Object>();

    public DefaultJavaAnnotation(JavaClass type, Map<String, Object> namedParameters) {
        this.type = type;
        if (this.properties != null) {
            for (Map.Entry<String, AnnotationValue> entry : this.properties.entrySet()) {
                String name = entry.getKey();
                AnnotationValue value = entry.getValue();
                this.setProperty(name, value);
            }
        }
    }

    public DefaultJavaAnnotation(JavaClass type) {
        this(type, null);
    }

    public final void setProperty(String name, AnnotationValue value) {
        this.properties.put(name, value);
        this.namedParameters.put(name, value.getParameterValue());
    }

    @Override
    public JavaClass getType() {
        return this.type;
    }

    @Override
    public DefaultJavaAnnotation getParameterValue() {
        return this;
    }

    @Override
    public Map<String, AnnotationValue> getPropertyMap() {
        return this.properties;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('@');
        result.append(this.type.getFullyQualifiedName());
        result.append('(');
        if (!this.namedParameters.isEmpty()) {
            Iterator<Map.Entry<String, Object>> i2 = this.namedParameters.entrySet().iterator();
            while (i2.hasNext()) {
                result.append(i2.next());
                if (!i2.hasNext()) continue;
                result.append(',');
            }
        }
        result.append(')');
        return result.toString();
    }
}

