/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaField;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaInitializer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.AbstractInheritableJavaEntity;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaTypeVariable;
import java.util.LinkedList;
import java.util.List;

public class DefaultJavaClass
extends AbstractInheritableJavaEntity
implements JavaClass {
    private List<JavaConstructor> constructors = new LinkedList<JavaConstructor>();
    private List<JavaMethod> methods = new LinkedList<JavaMethod>();
    private List<JavaField> fields = new LinkedList<JavaField>();
    private List<JavaClass> classes = new LinkedList<JavaClass>();
    private boolean anInterface;
    private boolean anEnum;
    private boolean anAnnotation;
    private JavaType superClass;
    private List<JavaClass> implementz = new LinkedList<JavaClass>();
    private List<JavaInitializer> initializers = new LinkedList<JavaInitializer>();
    private List<DefaultJavaTypeVariable<JavaClass>> typeParameters = new LinkedList<DefaultJavaTypeVariable<JavaClass>>();
    private JavaPackage javaPackage;

    protected DefaultJavaClass() {
    }

    public DefaultJavaClass(String name) {
        this.setName(name);
    }

    public DefaultJavaClass(JavaSource source) {
        this.setSource(source);
    }

    @Override
    public boolean isInterface() {
        return this.anInterface;
    }

    public boolean isPrimitive() {
        String name = this.getName();
        return "void".equals(name) || "boolean".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name) || "int".equals(name) || "long".equals(name) || "float".equals(name) || "double".equals(name);
    }

    @Override
    public boolean isEnum() {
        return this.anEnum;
    }

    @Override
    public boolean isAnnotation() {
        return this.anAnnotation;
    }

    @Override
    public JavaType getSuperClass() {
        JavaType result = null;
        if (this.isPrimitive()) {
            return null;
        }
        JavaClass OBJECT_JAVACLASS = this.getJavaClassLibrary().getJavaClass("java.lang.Object");
        JavaClass ENUM_JAVACLASS = this.getJavaClassLibrary().getJavaClass("java.lang.Enum");
        boolean iAmJavaLangObject = OBJECT_JAVACLASS.equals(this);
        result = this.anEnum ? ENUM_JAVACLASS : (!this.anInterface && !this.anAnnotation && this.superClass == null && !iAmJavaLangObject ? OBJECT_JAVACLASS : this.superClass);
        return result;
    }

    @Override
    public List<JavaType> getImplements() {
        return new LinkedList<JavaType>(this.implementz);
    }

    public void setInterface(boolean anInterface) {
        this.anInterface = anInterface;
    }

    public void setEnum(boolean anEnum) {
        this.anEnum = anEnum;
    }

    public void setAnnotation(boolean anAnnotation) {
        this.anAnnotation = anAnnotation;
    }

    public void addConstructor(JavaConstructor constructor) {
        this.constructors.add(constructor);
    }

    public void addMethod(JavaMethod meth) {
        this.methods.add(meth);
    }

    public void setSuperClass(JavaType type) {
        if (this.anEnum) {
            throw new IllegalArgumentException("enums cannot extend other classes");
        }
        this.superClass = type;
    }

    public void setImplementz(List<JavaClass> implementz) {
        this.implementz = implementz;
    }

    public List<DefaultJavaTypeVariable<JavaClass>> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(List<DefaultJavaTypeVariable<JavaClass>> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public void addField(JavaField javaField) {
        this.fields.add(javaField);
    }

    @Override
    public JavaSource getParentSource() {
        return this.getDeclaringClass() != null ? this.getDeclaringClass().getParentSource() : super.getSource();
    }

    @Override
    public JavaSource getSource() {
        return this.getParentSource();
    }

    public JavaPackage getPackage() {
        return this.getParentSource() != null ? this.getParentSource().getPackage() : this.javaPackage;
    }

    @Override
    public String getPackageName() {
        JavaPackage pckg = this.getPackage();
        return pckg != null && pckg.getName() != null ? pckg.getName() : "";
    }

    public String getSimpleName() {
        return this.getName();
    }

    @Override
    public String getBinaryName() {
        return this.getDeclaringClass() == null ? this.getCanonicalName() : this.getDeclaringClass().getBinaryName() + '$' + this.getSimpleName();
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        if (this.getDeclaringClass() == null) {
            return (this.getPackage() == null ? "" : this.getPackage().getName() + '.') + this.getSimpleName();
        }
        return this.getDeclaringClass().getFullyQualifiedName() + "." + this.getSimpleName();
    }

    @Override
    public String getCanonicalName() {
        return this.getFullyQualifiedName().replace('$', '.');
    }

    @Override
    public String getGenericCanonicalName() {
        return this.getCanonicalName();
    }

    @Override
    public String getValue() {
        return this.getCanonicalName().substring(this.getSource().getClassNamePrefix().length());
    }

    @Override
    public List<JavaConstructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    @Override
    public List<JavaField> getFields() {
        return this.fields;
    }

    public void addInitializer(JavaInitializer initializer) {
        this.initializers.add(initializer);
    }

    public void addClass(JavaClass cls) {
        this.classes.add(cls);
    }

    @Override
    public List<JavaClass> getNestedClasses() {
        return this.classes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isPrimitive()) {
            sb.append(this.getName());
        } else {
            sb.append(this.isInterface() ? "interface" : "class");
            sb.append(" ");
            sb.append(this.getFullyQualifiedName());
        }
        return sb.toString();
    }

    public int hashCode() {
        return 2 + this.getFullyQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaClass)) {
            return false;
        }
        JavaClass clazz = (JavaClass)obj;
        return this.getFullyQualifiedName().equals(clazz.getFullyQualifiedName());
    }

    public ClassLibrary getJavaClassLibrary() {
        return this.getSource().getJavaClassLibrary();
    }
}

