/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaParameter;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaTypeVariable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaExecutable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultJavaConstructor
extends DefaultJavaExecutable
implements JavaConstructor {
    private List<JavaTypeVariable<JavaConstructor>> typeParameters = Collections.emptyList();

    public void setTypeParameters(List<JavaTypeVariable<JavaConstructor>> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public List<JavaTypeVariable<JavaConstructor>> getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isPrivate()) {
            result.append("private ");
        } else if (this.isProtected()) {
            result.append("protected ");
        } else if (this.isPublic()) {
            result.append("public ");
        }
        if (this.getDeclaringClass() != null) {
            result.append(this.getDeclaringClass().getFullyQualifiedName());
        }
        result.append("(");
        Iterator<JavaParameter> paramIter = this.getParameters().iterator();
        while (paramIter.hasNext()) {
            String typeValue = DefaultJavaType.getResolvedValue(paramIter.next().getType(), this.getTypeParameters());
            result.append(typeValue);
            if (!paramIter.hasNext()) continue;
            result.append(",");
        }
        result.append(")");
        if (this.getExceptions().size() > 0) {
            result.append(" throws ");
            Iterator<JavaClass> excIter = this.getExceptions().iterator();
            while (excIter.hasNext()) {
                result.append(excIter.next().getValue());
                if (!excIter.hasNext()) continue;
                result.append(",");
            }
        }
        return result.toString();
    }

    public int hashCode() {
        int hashCode = 3 + this.getName().hashCode();
        return hashCode *= 31 + this.getParameters().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaConstructor)) {
            return false;
        }
        JavaConstructor c2 = (JavaConstructor)obj;
        if (c2.getDeclaringClass() != null ? !c2.getDeclaringClass().equals(this.getDeclaringClass()) : this.getDeclaringClass() != null) {
            return false;
        }
        if (!c2.getName().equals(this.getName())) {
            return false;
        }
        List<JavaParameter> myParams = this.getParameters();
        List<JavaParameter> otherParams = c2.getParameters();
        if (otherParams.size() != myParams.size()) {
            return false;
        }
        for (int i2 = 0; i2 < myParams.size(); ++i2) {
            if (otherParams.get(i2).equals(myParams.get(i2))) continue;
            return false;
        }
        return this.isVarArgs() == c2.isVarArgs();
    }
}

