/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaParameter;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaTypeVariable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaExecutable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultJavaMethod
extends DefaultJavaExecutable
implements JavaMethod {
    private boolean defaultMethod;
    private JavaClass returns;
    private List<JavaTypeVariable<JavaMethod>> typeParameters = Collections.emptyList();

    public void setDefault(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    public JavaClass getReturns() {
        return this.returns;
    }

    public void setTypeParameters(List<JavaTypeVariable<JavaMethod>> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public List<JavaTypeVariable<JavaMethod>> getTypeParameters() {
        return this.typeParameters;
    }

    public void setReturns(JavaClass returns) {
        this.returns = returns;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaMethod)) {
            return false;
        }
        JavaMethod other = (JavaMethod)obj;
        if (other.getDeclaringClass() != null ? !other.getDeclaringClass().equals(this.getDeclaringClass()) : this.getDeclaringClass() != null) {
            return false;
        }
        if (other.getName() != null ? !other.getName().equals(this.getName()) : this.getName() != null) {
            return false;
        }
        if (other.getReturnType() != null ? !other.getReturnType().equals(this.getReturns()) : this.getReturns() != null) {
            return false;
        }
        List<JavaParameter> thisParams = this.getParameters();
        List<JavaParameter> otherParams = other.getParameters();
        if (otherParams.size() != thisParams.size()) {
            return false;
        }
        for (int i2 = 0; i2 < thisParams.size(); ++i2) {
            if (otherParams.get(i2).equals(thisParams.get(i2))) continue;
            return false;
        }
        return this.isVarArgs() == other.isVarArgs();
    }

    public int hashCode() {
        int hashCode = 7;
        if (this.getDeclaringClass() != null) {
            hashCode *= 31 + this.getDeclaringClass().hashCode();
        }
        if (this.getName() != null) {
            hashCode *= 37 + this.getName().hashCode();
        }
        hashCode *= 41 + this.getParameters().hashCode();
        if (this.returns != null) {
            hashCode *= 43 + this.returns.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isPrivate()) {
            result.append("private ");
        } else if (this.isProtected()) {
            result.append("protected ");
        } else if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isAbstract()) {
            result.append("abstract ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isSynchronized()) {
            result.append("synchronized ");
        }
        if (this.isNative()) {
            result.append("native ");
        }
        result.append(this.getReturns().getFullyQualifiedName()).append(' ');
        if (this.getDeclaringClass() != null) {
            result.append(this.getDeclaringClass().getBinaryName());
            result.append(".");
        }
        result.append(this.getName());
        result.append("(");
        for (int paramIndex = 0; paramIndex < this.getParameters().size(); ++paramIndex) {
            JavaType originalType;
            JavaTypeVariable typeVariable;
            if (paramIndex > 0) {
                result.append(",");
            }
            result.append((typeVariable = DefaultJavaType.resolve(originalType = this.getParameters().get(paramIndex).getType(), this.getTypeParameters())) == null ? originalType.getFullyQualifiedName() : typeVariable.getBounds().get(0).getFullyQualifiedName());
        }
        result.append(")");
        if (this.getExceptions().size() > 0) {
            result.append(" throws ");
            Iterator<JavaClass> excIter = this.getExceptions().iterator();
            while (excIter.hasNext()) {
                result.append(excIter.next().getFullyQualifiedName());
                if (!excIter.hasNext()) continue;
                result.append(",");
            }
        }
        return result.toString();
    }

    @Override
    public JavaType getReturnType() {
        return this.getReturnType(false);
    }

    public JavaType getReturnType(boolean resolve) {
        return this.returns;
    }
}

