/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.DocletTag;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotation;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaField;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaGenericDeclaration;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaTypeVariable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.type.TypeResolver;
import java.io.Serializable;
import java.util.List;

public class DefaultJavaType
implements JavaClass,
Serializable {
    protected final String name;
    protected String fullName;
    private int dimensions;
    private TypeResolver typeResolver;

    DefaultJavaType(String name, TypeResolver typeResolver) {
        this.name = name;
        this.typeResolver = typeResolver;
    }

    DefaultJavaType(String fullName, String name, int dimensions, TypeResolver typeResolver) {
        this.fullName = fullName;
        this.name = name;
        this.dimensions = dimensions;
        this.typeResolver = typeResolver;
    }

    DefaultJavaType(String fullName, int dimensions) {
        this.name = fullName;
        this.fullName = fullName;
        this.dimensions = dimensions;
    }

    DefaultJavaType(String fullName) {
        this(fullName, 0);
    }

    @Override
    public String getBinaryName() {
        return this.resolveRealClass().getBinaryName();
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder result = new StringBuilder(this.resolveRealClass().getFullyQualifiedName());
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            result.append("[]");
        }
        return result.toString();
    }

    public JavaClass getComponentType() {
        return this.isArray() ? this.resolveRealClass() : null;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder(this.name);
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            result.append("[]");
        }
        return result.toString();
    }

    protected static <D extends JavaGenericDeclaration> String getResolvedValue(JavaType base, List<JavaTypeVariable<D>> typeParameters) {
        String result = base.getValue();
        for (JavaTypeVariable<D> typeParameter : typeParameters) {
            if (!typeParameter.getName().equals(base.getValue())) continue;
            result = typeParameter.getBounds().get(0).getValue();
            break;
        }
        return result;
    }

    protected static <D extends JavaGenericDeclaration> JavaTypeVariable<D> resolve(JavaType base, List<JavaTypeVariable<D>> typeParameters) {
        JavaTypeVariable<D> result = null;
        for (JavaTypeVariable<D> typeParameter : typeParameters) {
            if (!typeParameter.getName().equals(base.getValue())) continue;
            result = typeParameter;
            break;
        }
        return result;
    }

    protected boolean isResolved() {
        if (this.fullName == null && this.typeResolver != null) {
            this.fullName = this.typeResolver.resolveType(this.name);
        }
        return this.fullName != null;
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaType)) {
            return false;
        }
        JavaType t2 = (JavaType)obj;
        return this.getFullyQualifiedName().equals(t2.getFullyQualifiedName());
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    private JavaClass resolveRealClass() {
        JavaClass result = null;
        String qualifiedName = this.isResolved() ? this.fullName : this.name;
        result = DefaultJavaType.isPrimitive(qualifiedName) ? new DefaultJavaClass(qualifiedName) : this.typeResolver.getJavaClass(qualifiedName);
        return result;
    }

    private static boolean isPrimitive(String value) {
        return "void".equals(value) || "boolean".equals(value) || "byte".equals(value) || "char".equals(value) || "short".equals(value) || "int".equals(value) || "long".equals(value) || "float".equals(value) || "double".equals(value);
    }

    @Override
    public String getGenericCanonicalName() {
        StringBuilder result = new StringBuilder(this.getCanonicalName());
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public JavaSource getSource() {
        return this.resolveRealClass().getSource();
    }

    @Override
    public boolean isInterface() {
        return this.resolveRealClass().isInterface();
    }

    @Override
    public List<JavaAnnotation> getAnnotations() {
        return this.resolveRealClass().getAnnotations();
    }

    @Override
    public boolean isEnum() {
        return this.resolveRealClass().isEnum();
    }

    @Override
    public String getComment() {
        return this.resolveRealClass().getComment();
    }

    @Override
    public List<DocletTag> getTags() {
        return this.resolveRealClass().getTags();
    }

    @Override
    public boolean isAnnotation() {
        return this.resolveRealClass().isAnnotation();
    }

    @Override
    public JavaType getSuperClass() {
        return this.resolveRealClass().getSuperClass();
    }

    @Override
    public List<JavaType> getImplements() {
        return this.resolveRealClass().getImplements();
    }

    @Override
    public <D extends JavaGenericDeclaration> List<JavaTypeVariable<D>> getTypeParameters() {
        return this.resolveRealClass().getTypeParameters();
    }

    @Override
    public JavaSource getParentSource() {
        return this.resolveRealClass().getParentSource();
    }

    @Override
    public String getPackageName() {
        return this.resolveRealClass().getPackageName();
    }

    @Override
    public List<JavaMethod> getMethods() {
        return this.resolveRealClass().getMethods();
    }

    @Override
    public List<JavaConstructor> getConstructors() {
        return this.resolveRealClass().getConstructors();
    }

    @Override
    public List<JavaField> getFields() {
        return this.resolveRealClass().getFields();
    }

    @Override
    public List<JavaClass> getNestedClasses() {
        return this.resolveRealClass().getNestedClasses();
    }

    @Override
    public String getName() {
        return this.resolveRealClass().getName();
    }

    @Override
    public String getCanonicalName() {
        StringBuilder result = new StringBuilder(this.resolveRealClass().getCanonicalName());
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public List<String> getModifiers() {
        return this.resolveRealClass().getModifiers();
    }
}

