/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.jodah.failsafe;

import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.AsyncExecution;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.Execution;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.ExecutionResult;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.FailsafeException;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.FailsafeFuture;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.Functions;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.Policy;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.PolicyListeners;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.event.ExecutionCompletedEvent;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.function.CheckedConsumer;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.function.CheckedSupplier;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.internal.EventListener;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.internal.util.Assert;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.util.concurrent.Scheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public class FailsafeExecutor<R>
extends PolicyListeners<FailsafeExecutor<R>, R> {
    private Scheduler scheduler = Scheduler.DEFAULT;
    final List<Policy<R>> policies;
    private EventListener completeListener;

    FailsafeExecutor(List<Policy<R>> policies) {
        Assert.isTrue(!policies.isEmpty(), "At least one policy must be supplied", new Object[0]);
        this.policies = policies;
    }

    public <T extends R> T get(CheckedSupplier<T> supplier) {
        return this.call(execution -> Assert.notNull(supplier, "supplier"));
    }

    public <T extends R> CompletableFuture<T> getStageAsync(CheckedSupplier<? extends CompletionStage<T>> supplier) {
        return this.callAsync(execution -> Functions.getPromiseOfStage(Functions.toCtxSupplier(supplier), execution), false);
    }

    @Override
    public FailsafeExecutor<R> onSuccess(CheckedConsumer<? extends ExecutionCompletedEvent<R>> listener) {
        return (FailsafeExecutor)super.onSuccess(listener);
    }

    void handleComplete(ExecutionResult result, ExecutionContext context) {
        if (this.successListener != null && result.getSuccessAll()) {
            this.successListener.handle(result, context.copy());
        } else if (this.failureListener != null && !result.getSuccessAll()) {
            this.failureListener.handle(result, context.copy());
        }
        if (this.completeListener != null) {
            this.completeListener.handle(result, context.copy());
        }
    }

    private <T> T call(Function<Execution, CheckedSupplier<?>> supplierFn) {
        Execution execution = new Execution(this);
        Supplier<ExecutionResult> supplier = Functions.get(supplierFn.apply(execution), execution);
        ExecutionResult result = execution.executeSync(supplier);
        Throwable failure = result.getFailure();
        if (failure != null) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new FailsafeException(failure);
        }
        return (T)result.getResult();
    }

    private <T> CompletableFuture<T> callAsync(Function<AsyncExecution, Supplier<CompletableFuture<ExecutionResult>>> supplierFn, boolean asyncExecution) {
        FailsafeFuture future = new FailsafeFuture(this);
        AsyncExecution execution = new AsyncExecution(this.scheduler, future, this);
        future.inject(execution);
        execution.inject(supplierFn.apply(execution), asyncExecution);
        execution.executeAsync(asyncExecution);
        return future;
    }
}

