/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleNameExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

class ManifestModuleNameExtractor
implements ModuleNameExtractor {
    ManifestModuleNameExtractor() {
    }

    @Override
    public String extract(Path file) throws IOException {
        Manifest manifest = this.extractManifest(file.toFile());
        String automaticModuleName = manifest != null ? manifest.getMainAttributes().getValue("Automatic-Module-Name") : null;
        return automaticModuleName;
    }

    private Manifest extractManifest(File file) throws IOException {
        Manifest manifest;
        if (file.isFile()) {
            try (JarFile jarFile = new JarFile(file);){
                manifest = jarFile.getManifest();
            }
        } else if (new File(file, "META-INF/MANIFEST.MF").exists()) {
            try (FileInputStream is = new FileInputStream(new File(file, "META-INF/MANIFEST.MF"));){
                manifest = new Manifest(is);
            }
        } else {
            manifest = null;
        }
        return manifest;
    }
}

