/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.Locale;

public abstract class BufferingResponseListener
extends Response.Listener.Adapter {
    private final int maxLength;
    private ByteBuffer buffer;
    private String mediaType;
    private String encoding;

    public BufferingResponseListener() {
        this(0x200000);
    }

    public BufferingResponseListener(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Invalid max length " + maxLength);
        }
        this.maxLength = maxLength;
    }

    @Override
    public void onHeaders(Response response) {
        super.onHeaders(response);
        Request request = response.getRequest();
        HttpFields headers = response.getHeaders();
        long length = headers.getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (HttpMethod.HEAD.is(request.getMethod())) {
            length = 0L;
        }
        if (length > (long)this.maxLength) {
            response.abort(new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
            return;
        }
        String contentType = headers.get(HttpHeader.CONTENT_TYPE);
        if (contentType != null) {
            int semicolon;
            String media = contentType;
            String charset = "charset=";
            int index = contentType.toLowerCase(Locale.ENGLISH).indexOf(charset);
            if (index > 0) {
                media = contentType.substring(0, index);
                String encoding = contentType.substring(index + charset.length());
                int semicolon2 = encoding.indexOf(59);
                if (semicolon2 > 0) {
                    encoding = encoding.substring(0, semicolon2).trim();
                }
                int lastIndex = encoding.length() - 1;
                if (encoding.charAt(0) == '\"' && encoding.charAt(lastIndex) == '\"') {
                    encoding = encoding.substring(1, lastIndex).trim();
                }
                this.encoding = encoding;
            }
            if ((semicolon = media.indexOf(59)) > 0) {
                media = media.substring(0, semicolon).trim();
            }
            this.mediaType = media;
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        int length = content.remaining();
        if (length > BufferUtil.space(this.buffer)) {
            int remaining;
            int n2 = remaining = this.buffer == null ? 0 : this.buffer.remaining();
            if (remaining + length > this.maxLength) {
                response.abort(new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
            }
            int requiredCapacity = this.buffer == null ? length : this.buffer.capacity() + length;
            int newCapacity = Math.min(Integer.highestOneBit(requiredCapacity) << 1, this.maxLength);
            this.buffer = BufferUtil.ensureCapacity(this.buffer, newCapacity);
        }
        BufferUtil.append(this.buffer, content);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getContent() {
        if (this.buffer == null) {
            return new byte[0];
        }
        return BufferUtil.toArray(this.buffer);
    }
}

