/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.Http1FieldPreEncoder;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFieldPreEncoder;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;

public class PreEncodedHttpField
extends HttpField {
    private static final Logger LOG = Log.getLogger(PreEncodedHttpField.class);
    private static final HttpFieldPreEncoder[] __encoders;
    private final byte[][] _encodedField = new byte[__encoders.length][];

    private static int index(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: 
            case HTTP_1_1: {
                return 0;
            }
            case HTTP_2: {
                return 1;
            }
        }
        return -1;
    }

    public PreEncodedHttpField(HttpHeader header, String name, String value) {
        super(header, name, value);
        for (int i2 = 0; i2 < __encoders.length; ++i2) {
            this._encodedField[i2] = __encoders[i2].getEncodedField(header, name, value);
        }
    }

    public PreEncodedHttpField(HttpHeader header, String value) {
        this(header, header.asString(), value);
    }

    public void putTo(ByteBuffer bufferInFillMode, HttpVersion version) {
        bufferInFillMode.put(this._encodedField[PreEncodedHttpField.index(version)]);
    }

    static {
        ArrayList<HttpFieldPreEncoder> encoders = new ArrayList<HttpFieldPreEncoder>();
        Iterator<HttpFieldPreEncoder> iter = ServiceLoader.load(HttpFieldPreEncoder.class).iterator();
        while (iter.hasNext()) {
            try {
                HttpFieldPreEncoder encoder = iter.next();
                if (PreEncodedHttpField.index(encoder.getHttpVersion()) < 0) continue;
                encoders.add(encoder);
            }
            catch (Error | RuntimeException e2) {
                LOG.debug(e2);
            }
        }
        LOG.debug("HttpField encoders loaded: {}", encoders);
        int size = encoders.size();
        __encoders = new HttpFieldPreEncoder[size == 0 ? 1 : size];
        for (HttpFieldPreEncoder e3 : encoders) {
            int i2 = PreEncodedHttpField.index(e3.getHttpVersion());
            if (__encoders[i2] == null) {
                PreEncodedHttpField.__encoders[i2] = e3;
                continue;
            }
            LOG.warn("multiple PreEncoders for " + (Object)((Object)e3.getHttpVersion()), new Object[0]);
        }
        if (__encoders[0] == null) {
            PreEncodedHttpField.__encoders[0] = new Http1FieldPreEncoder();
        }
    }
}

