/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.MultiMap;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.UrlEncoded;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client.WebSocketUpgradeRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.UpgradeRequestAdapter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;

public class ClientUpgradeRequest
extends UpgradeRequestAdapter {
    private static final Set<String> FORBIDDEN_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final String key = this.genRandomKey();

    public ClientUpgradeRequest() {
    }

    protected ClientUpgradeRequest(URI requestURI) {
        super(requestURI);
    }

    public ClientUpgradeRequest(WebSocketUpgradeRequest wsRequest) {
        this(wsRequest.getURI());
        this.setCookies(wsRequest.getCookies());
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HttpFields fields = wsRequest.getHeaders();
        for (HttpField field : fields) {
            String key = field.getName();
            ArrayList<String> values = (ArrayList<String>)headers.get(key);
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.addAll(Arrays.asList(field.getValues()));
            headers.put(key, values);
            if (key.equalsIgnoreCase("Sec-WebSocket-Protocol")) {
                for (String subProtocol : field.getValue().split(",")) {
                    this.setSubProtocols(subProtocol);
                }
            }
            if (!key.equalsIgnoreCase("Sec-WebSocket-Extensions")) continue;
            for (ExtensionConfig ext : ExtensionConfig.parseList(field.getValues())) {
                this.addExtensions(ext);
            }
        }
        super.setHeaders(headers);
        this.setHttpVersion(wsRequest.getVersion().toString());
        this.setMethod(wsRequest.getMethod());
    }

    private final String genRandomKey() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    @Override
    public void setRequestURI(URI uri) {
        super.setRequestURI(uri);
        HashMap<String, List<String>> pmap = new HashMap<String, List<String>>();
        String query = uri.getRawQuery();
        if (StringUtil.isNotBlank(query)) {
            MultiMap<String> params = new MultiMap<String>();
            UrlEncoded.decodeTo(query, params, StandardCharsets.UTF_8);
            for (String key : params.keySet()) {
                List<String> values = params.getValues(key);
                if (values == null) {
                    pmap.put(key, new ArrayList());
                    continue;
                }
                ArrayList<String> copy = new ArrayList<String>();
                copy.addAll(values);
                pmap.put(key, copy);
            }
            super.setParameterMap(pmap);
        }
    }

    static {
        FORBIDDEN_HEADERS.add("cookie");
        FORBIDDEN_HEADERS.add("upgrade");
        FORBIDDEN_HEADERS.add("host");
        FORBIDDEN_HEADERS.add("connection");
        FORBIDDEN_HEADERS.add("sec-websocket-key");
        FORBIDDEN_HEADERS.add("sec-websocket-extensions");
        FORBIDDEN_HEADERS.add("sec-websocket-accept");
        FORBIDDEN_HEADERS.add("sec-websocket-protocol");
        FORBIDDEN_HEADERS.add("sec-websocket-version");
        FORBIDDEN_HEADERS.add("pragma");
        FORBIDDEN_HEADERS.add("cache-control");
    }
}

