/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.DecoratedObjectFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ShutdownThread;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client.HttpClientProvider;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.SessionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.SessionTracker;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSession;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class WebSocketClient
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final HttpClient httpClient;
    private final Supplier<DecoratedObjectFactory> objectFactorySupplier;
    private final ClassLoader classloader;
    private final WebSocketPolicy policy;
    private final WebSocketExtensionFactory extensionRegistry;
    private final SessionTracker sessionTracker = new SessionTracker();
    private final List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();
    private EventDriverFactory eventDriverFactory;
    private SessionFactory sessionFactory;
    private boolean stopAtShutdown = true;

    public WebSocketClient() {
        this(HttpClientProvider.get(null), null);
    }

    public WebSocketClient(HttpClient httpClient) {
        this(httpClient, null);
    }

    public WebSocketClient(HttpClient httpClient, DecoratedObjectFactory decoratedObjectFactory) {
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.httpClient = Objects.requireNonNull(httpClient, "HttpClient");
        this.addBean(httpClient);
        this.addBean(this.sessionTracker);
        this.addSessionListener(this.sessionTracker);
        this.policy = WebSocketPolicy.newClientPolicy();
        DecoratedObjectFactory objectFactory = decoratedObjectFactory == null ? new DecoratedObjectFactory() : decoratedObjectFactory;
        this.objectFactorySupplier = () -> objectFactory;
        this.extensionRegistry = new WebSocketExtensionFactory(this);
        this.addBean(this.extensionRegistry);
        this.eventDriverFactory = new EventDriverFactory(this);
        this.sessionFactory = new WebSocketSessionFactory(this);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    @Override
    protected void doStart() throws Exception {
        Objects.requireNonNull(this.httpClient, "Provided HttpClient is null");
        super.doStart();
        if (!this.httpClient.isRunning()) {
            throw new IllegalStateException("HttpClient is not running (did you forget to start it?): " + this.httpClient);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        ShutdownThread.deregister(this);
        this.sessionTracker.stop();
        this.extensionRegistry.stop();
        super.doStop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", this);
        }
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.httpClient.getByteBufferPool();
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    @Override
    public Executor getExecutor() {
        return this.httpClient.getExecutor();
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactorySupplier.get();
    }

    public Set<WebSocketSession> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.httpClient.getScheduler();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.httpClient.getSslContextFactory();
    }

    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    @Override
    public Collection<WebSocketSessionListener> getSessionListeners() {
        return this.sessionListeners;
    }

    public void setConnectTimeout(long ms) {
        this.httpClient.setConnectTimeout(ms);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public synchronized void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this.stopAtShutdown && this.isStarted() && !ShutdownThread.isRegistered(this)) {
                ShutdownThread.register(this);
            }
        } else {
            ShutdownThread.deregister(this);
        }
        this.stopAtShutdown = stop;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof WebSocketClient)) {
            return false;
        }
        WebSocketClient that = (WebSocketClient)o2;
        return Objects.equals(this.httpClient, that.httpClient) && Objects.equals(this.policy, that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.httpClient, this.policy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WebSocketClient@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append("[httpClient=").append(this.httpClient);
        sb.append(",openSessions.size=");
        sb.append(this.getOpenSessions().size());
        sb.append(']');
        return sb.toString();
    }
}

