/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.extensions.compress;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferAccumulator;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.IteratingCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.compression.DeflaterPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.compression.InflaterPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.BatchMode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WriteCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.OpCode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.frames.DataFrame;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public abstract class CompressExtension
extends AbstractExtension {
    protected static final byte[] TAIL_BYTES = new byte[]{0, 0, -1, -1};
    protected static final ByteBuffer TAIL_BYTES_BUF = ByteBuffer.wrap(TAIL_BYTES);
    private static final Logger LOG = Log.getLogger(CompressExtension.class);
    private final Queue<FrameEntry> entries = new ArrayDeque<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private DeflaterPool deflaterPool;
    private InflaterPool inflaterPool;
    private Deflater deflaterImpl;
    private Inflater inflaterImpl;
    protected AtomicInteger decompressCount = new AtomicInteger(0);
    private int tailDrop = this.getTailDropMode();
    private int rsvUse = this.getRsvUseMode();

    protected CompressExtension() {
    }

    public void setInflaterPool(InflaterPool inflaterPool) {
        this.inflaterPool = inflaterPool;
    }

    public void setDeflaterPool(DeflaterPool deflaterPool) {
        this.deflaterPool = deflaterPool;
    }

    public Deflater getDeflater() {
        if (this.deflaterImpl == null) {
            this.deflaterImpl = (Deflater)this.deflaterPool.acquire();
        }
        return this.deflaterImpl;
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    abstract int getTailDropMode();

    abstract int getRsvUseMode();

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (this.flusher.isFailed()) {
            this.notifyCallbackFailure(callback, new ZipException());
            return;
        }
        FrameEntry entry = new FrameEntry(frame, callback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", entry);
        }
        this.offerEntry(entry);
        this.flusher.iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEntry(FrameEntry entry) {
        CompressExtension compressExtension = this;
        synchronized (compressExtension) {
            this.entries.offer(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameEntry pollEntry() {
        CompressExtension compressExtension = this;
        synchronized (compressExtension) {
            return this.entries.poll();
        }
    }

    protected void notifyCallbackSuccess(WriteCallback callback) {
        block3: {
            try {
                if (callback != null) {
                    callback.writeSuccess();
                }
            }
            catch (Throwable x2) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + callback, x2);
            }
        }
    }

    protected void notifyCallbackFailure(WriteCallback callback, Throwable failure) {
        block3: {
            try {
                if (callback != null) {
                    callback.writeFailed(failure);
                }
            }
            catch (Throwable x2) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + callback, x2);
            }
        }
    }

    private static boolean supplyInput(Deflater deflater, ByteBuffer buf) {
        int inputOffset;
        byte[] input;
        int len;
        if (buf == null || buf.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Deflater", new Object[0]);
            }
            return false;
        }
        if (buf.hasArray()) {
            len = buf.remaining();
            input = buf.array();
            inputOffset = buf.position() + buf.arrayOffset();
            buf.position(buf.position() + len);
        } else {
            len = Math.min(8192, buf.remaining());
            input = new byte[len];
            inputOffset = 0;
            buf.get(input, 0, len);
        }
        deflater.setInput(input, inputOffset, len);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", input.length, CompressExtension.toDetail(deflater));
        }
        return true;
    }

    private static String toDetail(Deflater deflater) {
        return String.format("Deflater[finished=%b,read=%d,written=%d,in=%d,out=%d]", deflater.finished(), deflater.getBytesRead(), deflater.getBytesWritten(), deflater.getTotalIn(), deflater.getTotalOut());
    }

    public static boolean endsWithTail(ByteBuffer buf) {
        if (buf == null || buf.remaining() < TAIL_BYTES.length) {
            return false;
        }
        int limit = buf.limit();
        for (int i2 = TAIL_BYTES.length; i2 > 0; --i2) {
            if (buf.get(limit - i2) == TAIL_BYTES[TAIL_BYTES.length - i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.deflaterImpl != null) {
            this.deflaterPool.release(this.deflaterImpl);
            this.deflaterImpl = null;
        }
        if (this.inflaterImpl != null) {
            this.inflaterPool.release(this.inflaterImpl);
            this.inflaterImpl = null;
        }
        super.doStop();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        @Override
        public void failed(Throwable x2) {
            CompressExtension.this.notifyCallbackFailure(this.current.callback, x2);
            super.failed(x2);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this.finished) {
                this.current = CompressExtension.this.pollEntry();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing {}", this.current);
                }
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.deflate(this.current);
            } else {
                this.compress(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void deflate(FrameEntry entry) {
            Frame frame = entry.frame;
            BatchMode batchMode = entry.batchMode;
            if (OpCode.isControlFrame(frame.getOpCode())) {
                CompressExtension.this.nextOutgoingFrame(frame, this, batchMode);
                return;
            }
            this.compress(entry, true);
        }

        private void compress(FrameEntry entry, boolean first) {
            Frame frame = entry.frame;
            boolean fin = frame.isFin();
            ByteBuffer data = frame.getPayload();
            Deflater deflater = CompressExtension.this.getDeflater();
            if (data == null) {
                data = BufferUtil.EMPTY_BUFFER;
            }
            int remaining = data.remaining();
            int outputLength = Math.max(256, data.remaining());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressing {}: {} bytes in {} bytes chunk", entry, remaining, outputLength);
            }
            ByteBuffer payload = BufferUtil.EMPTY_BUFFER;
            WriteCallback callback = this;
            if (!deflater.needsInput() || CompressExtension.supplyInput(deflater, data)) {
                final ByteBufferPool bufferPool = CompressExtension.this.getBufferPool();
                try (ByteBufferAccumulator accumulator = new ByteBufferAccumulator(bufferPool, false);){
                    ByteBuffer buffer;
                    int compressed;
                    do {
                        buffer = accumulator.ensureBuffer(8, outputLength);
                        compressed = deflater.deflate(buffer.array(), buffer.arrayOffset() + buffer.limit(), buffer.capacity() - buffer.limit(), 2);
                        buffer.limit(buffer.limit() + compressed);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Wrote {} bytes to output buffer", accumulator);
                    } while (compressed > 0);
                    payload = buffer = accumulator.takeByteBuffer();
                    callback = new WriteCallback(){

                        @Override
                        public void writeFailed(Throwable x2) {
                            bufferPool.release(buffer);
                            Flusher.this.writeFailed(x2);
                        }

                        @Override
                        public void writeSuccess() {
                            bufferPool.release(buffer);
                            Flusher.this.writeSuccess();
                        }
                    };
                }
            }
            if (payload.remaining() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("compressed[] bytes = {}", BufferUtil.toDetailString(payload));
                }
                if (CompressExtension.this.tailDrop == 1) {
                    if (CompressExtension.endsWithTail(payload)) {
                        payload.limit(payload.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_ALWAYS) = {}", BufferUtil.toDetailString(payload));
                    }
                } else if (CompressExtension.this.tailDrop == 2) {
                    if (frame.isFin() && CompressExtension.endsWithTail(payload)) {
                        payload.limit(payload.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_FIN_ONLY) = {}", BufferUtil.toDetailString(payload));
                    }
                }
            } else if (fin) {
                payload = ByteBuffer.wrap(new byte[]{0});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressed {}: input:{} -> payload:{}", entry, outputLength, payload.remaining());
            }
            boolean continuation = frame.getType().isContinuation() || !first;
            DataFrame chunk = new DataFrame(frame, continuation);
            if (CompressExtension.this.rsvUse == 1) {
                chunk.setRsv1(!continuation);
            } else {
                chunk.setRsv1(true);
            }
            chunk.setPayload(payload);
            chunk.setFin(fin);
            CompressExtension.this.nextOutgoingFrame(chunk, callback, entry.batchMode);
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable x2) {
            FrameEntry entry;
            while ((entry = CompressExtension.this.pollEntry()) != null) {
                CompressExtension.this.notifyCallbackFailure(entry.callback, x2);
            }
        }

        @Override
        public void writeSuccess() {
            if (this.finished) {
                CompressExtension.this.notifyCallbackSuccess(this.current.callback);
            }
            this.succeeded();
        }

        @Override
        public void writeFailed(Throwable x2) {
            this.failed(x2);
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback callback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = callback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

