/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelNode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.InlineList;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.PropertyOrFieldReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InlineMap
extends SpelNodeImpl {
    private TypedValue constant;

    public InlineMap(int startPos, int endPos, SpelNodeImpl ... args) {
        super(startPos, endPos, args);
        this.checkIfConstant();
    }

    private void checkIfConstant() {
        boolean isConstant = true;
        int max = this.getChildCount();
        for (int c2 = 0; c2 < max; ++c2) {
            SpelNode child = this.getChild(c2);
            if (child instanceof Literal) continue;
            if (child instanceof InlineList) {
                InlineList inlineList = (InlineList)child;
                if (inlineList.isConstant()) continue;
                isConstant = false;
                break;
            }
            if (child instanceof InlineMap) {
                InlineMap inlineMap = (InlineMap)child;
                if (inlineMap.isConstant()) continue;
                isConstant = false;
                break;
            }
            if (c2 % 2 == 0 && child instanceof PropertyOrFieldReference) continue;
            isConstant = false;
            break;
        }
        if (isConstant) {
            LinkedHashMap<Object, List<Object>> constantMap = new LinkedHashMap<Object, List<Object>>();
            int childCount = this.getChildCount();
            for (int c3 = 0; c3 < childCount; ++c3) {
                SpelNode keyChild = this.getChild(c3++);
                SpelNode valueChild = this.getChild(c3);
                Object key = null;
                Object value = null;
                if (keyChild instanceof Literal) {
                    key = ((Literal)keyChild).getLiteralValue().getValue();
                } else if (keyChild instanceof PropertyOrFieldReference) {
                    key = ((PropertyOrFieldReference)keyChild).getName();
                } else {
                    return;
                }
                if (valueChild instanceof Literal) {
                    value = ((Literal)valueChild).getLiteralValue().getValue();
                } else if (valueChild instanceof InlineList) {
                    value = ((InlineList)valueChild).getConstantValue();
                } else if (valueChild instanceof InlineMap) {
                    value = ((InlineMap)valueChild).getConstantValue();
                }
                constantMap.put(key, (List<Object>)value);
            }
            this.constant = new TypedValue(Collections.unmodifiableMap(constantMap));
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        LinkedHashMap<Object, Object> returnValue = new LinkedHashMap<Object, Object>();
        int childcount = this.getChildCount();
        for (int c2 = 0; c2 < childcount; ++c2) {
            SpelNode keyChild = this.getChild(c2++);
            Object key = null;
            if (keyChild instanceof PropertyOrFieldReference) {
                PropertyOrFieldReference reference = (PropertyOrFieldReference)keyChild;
                key = reference.getName();
            } else {
                key = keyChild.getValue(expressionState);
            }
            Object value = this.getChild(c2).getValue(expressionState);
            returnValue.put(key, value);
        }
        return new TypedValue(returnValue);
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("{");
        int count = this.getChildCount();
        for (int c2 = 0; c2 < count; ++c2) {
            if (c2 > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(c2++).toStringAST());
            sb.append(":");
            sb.append(this.getChild(c2).toStringAST());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public Map<Object, Object> getConstantValue() {
        Assert.state(this.constant != null, "No constant");
        return (Map)this.constant.getValue();
    }
}

