/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.Label;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;

public class OpOr
extends Operator {
    public OpOr(int startPos, int endPos, SpelNodeImpl ... operands) {
        super("or", startPos, endPos, operands);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        if (this.getBooleanValue(state, this.getLeftOperand())) {
            return BooleanTypedValue.TRUE;
        }
        return BooleanTypedValue.forValue(this.getBooleanValue(state, this.getRightOperand()));
    }

    private boolean getBooleanValue(ExpressionState state, SpelNodeImpl operand) {
        try {
            Boolean value = operand.getValue(state, Boolean.class);
            this.assertValueNotNull(value);
            return value;
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(operand.getStartPosition());
            throw ee;
        }
    }

    private void assertValueNotNull(Boolean value) {
        if (value == null) {
            throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl left = this.getLeftOperand();
        SpelNodeImpl right = this.getRightOperand();
        return left.isCompilable() && right.isCompilable() && CodeFlow.isBooleanCompatible(left.exitTypeDescriptor) && CodeFlow.isBooleanCompatible(right.exitTypeDescriptor);
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf2) {
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        cf2.enterCompilationScope();
        this.getLeftOperand().generateCode(mv, cf2);
        cf2.unboxBooleanIfNecessary(mv);
        cf2.exitCompilationScope();
        mv.visitJumpInsn(153, elseTarget);
        mv.visitLdcInsn(1);
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        cf2.enterCompilationScope();
        this.getRightOperand().generateCode(mv, cf2);
        cf2.unboxBooleanIfNecessary(mv);
        cf2.exitCompilationScope();
        mv.visitLabel(endOfIf);
        cf2.pushDescriptor(this.exitTypeDescriptor);
    }
}

