/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Set;

public class BeanAsArrayDeserializer
extends BeanDeserializerBase {
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;

    public BeanAsArrayDeserializer(BeanDeserializerBase delegate, SettableBeanProperty[] ordered) {
        super(delegate);
        this._delegate = delegate;
        this._orderedProperties = ordered;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return this._delegate.unwrappingDeserializer(unwrapper);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader oir) {
        return new BeanAsArrayDeserializer(this._delegate.withObjectIdReader(oir), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withByNameInclusion(Set<String> ignorableProps, Set<String> includableProps) {
        return new BeanAsArrayDeserializer(this._delegate.withByNameInclusion(ignorableProps, includableProps), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean ignoreUnknown) {
        return new BeanAsArrayDeserializer(this._delegate.withIgnoreAllUnknown(ignoreUnknown), this._orderedProperties);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BeanAsArrayDeserializer(this._delegate.withBeanProperties(props), this._orderedProperties);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (!p2.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(p2, ctxt);
        }
        if (!this._vanillaProcessing) {
            return this._deserializeNonVanilla(p2, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p2.setCurrentValue(bean);
        SettableBeanProperty[] props = this._orderedProperties;
        int i2 = 0;
        int propCount = props.length;
        while (true) {
            if (p2.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            if (i2 == propCount) break;
            SettableBeanProperty prop = props[i2];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p2, ctxt, bean);
                }
                catch (Exception e2) {
                    this.wrapAndThrow(e2, bean, prop.getName(), ctxt);
                }
            } else {
                p2.skipChildren();
            }
            ++i2;
        }
        if (!this._ignoreAllUnknown && ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            ctxt.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        do {
            p2.skipChildren();
        } while (p2.nextToken() != JsonToken.END_ARRAY);
        return bean;
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt, Object bean) throws IOException {
        p2.setCurrentValue(bean);
        if (!p2.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(p2, ctxt);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        SettableBeanProperty[] props = this._orderedProperties;
        int i2 = 0;
        int propCount = props.length;
        while (true) {
            if (p2.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            if (i2 == propCount) break;
            SettableBeanProperty prop = props[i2];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p2, ctxt, bean);
                }
                catch (Exception e2) {
                    this.wrapAndThrow(e2, bean, prop.getName(), ctxt);
                }
            } else {
                p2.skipChildren();
            }
            ++i2;
        }
        if (!this._ignoreAllUnknown && ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            ctxt.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        do {
            p2.skipChildren();
        } while (p2.nextToken() != JsonToken.END_ARRAY);
        return bean;
    }

    @Override
    public Object deserializeFromObject(JsonParser p2, DeserializationContext ctxt) throws IOException {
        return this._deserializeFromNonArray(p2, ctxt);
    }

    protected Object _deserializeNonVanilla(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (this._nonStandardCreation) {
            return this.deserializeFromObjectUsingNonDefault(p2, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p2.setCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        SettableBeanProperty[] props = this._orderedProperties;
        int i2 = 0;
        int propCount = props.length;
        while (true) {
            if (p2.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            if (i2 == propCount) break;
            SettableBeanProperty prop = props[i2];
            ++i2;
            if (prop != null && (activeView == null || prop.visibleInView(activeView))) {
                try {
                    prop.deserializeAndSet(p2, ctxt, bean);
                }
                catch (Exception e2) {
                    this.wrapAndThrow(e2, bean, prop.getName(), ctxt);
                }
                continue;
            }
            p2.skipChildren();
        }
        if (!this._ignoreAllUnknown) {
            ctxt.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        do {
            p2.skipChildren();
        } while (p2.nextToken() != JsonToken.END_ARRAY);
        return bean;
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser p2, DeserializationContext ctxt) throws IOException {
        Class<?> activeView;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p2, ctxt, this._objectIdReader);
        SettableBeanProperty[] props = this._orderedProperties;
        int propCount = props.length;
        int i2 = 0;
        Object bean = null;
        Class<?> clazz = activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        while (p2.nextToken() != JsonToken.END_ARRAY) {
            block19: {
                SettableBeanProperty prop;
                SettableBeanProperty settableBeanProperty = prop = i2 < propCount ? props[i2] : null;
                if (prop == null) {
                    p2.skipChildren();
                } else if (activeView != null && !prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else if (bean != null) {
                    try {
                        prop.deserializeAndSet(p2, ctxt, bean);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean, prop.getName(), ctxt);
                    }
                } else {
                    String propName = prop.getName();
                    SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                    if (!buffer.readIdProperty(propName) || creatorProp != null) {
                        if (creatorProp != null) {
                            if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p2, ctxt))) {
                                try {
                                    bean = creator.build(ctxt, buffer);
                                }
                                catch (Exception e3) {
                                    this.wrapAndThrow(e3, this._beanType.getRawClass(), propName, ctxt);
                                    break block19;
                                }
                                p2.setCurrentValue(bean);
                                if (bean.getClass() != this._beanType.getRawClass()) {
                                    ctxt.reportBadDefinition(this._beanType, String.format("Cannot support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type %s, actual type %s", ClassUtil.getTypeDescription(this._beanType), ClassUtil.getClassDescription(bean)));
                                }
                            }
                        } else {
                            buffer.bufferProperty(prop, prop.deserialize(p2, ctxt));
                        }
                    }
                }
            }
            ++i2;
        }
        if (bean == null) {
            try {
                bean = creator.build(ctxt, buffer);
            }
            catch (Exception e4) {
                return this.wrapInstantiationProblem(e4, ctxt);
            }
        }
        return bean;
    }

    protected Object _deserializeFromNonArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String message = "Cannot deserialize a POJO (of type %s) from non-Array representation (token: %s): type/property designed to be serialized as JSON Array";
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2.currentToken(), p2, message, new Object[]{ClassUtil.getTypeDescription(this._beanType), p2.currentToken()});
    }
}

