/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Objects;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import java.io.Serializable;

public final class Suppliers {
    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        if (delegate instanceof NonSerializableMemoizingSupplier || delegate instanceof MemoizingSupplier) {
            return delegate;
        }
        return delegate instanceof Serializable ? new MemoizingSupplier<T>(delegate) : new NonSerializableMemoizingSupplier<T>(delegate);
    }

    public static <T> Supplier<T> ofInstance(T instance) {
        return new SupplierOfInstance<T>(instance);
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        final T instance;

        SupplierOfInstance(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SupplierOfInstance) {
                SupplierOfInstance that = (SupplierOfInstance)obj;
                return Objects.equal(this.instance, that.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }

        public String toString() {
            String string = String.valueOf(this.instance);
            return new StringBuilder(22 + String.valueOf(string).length()).append("Suppliers.ofInstance(").append(string).append(")").toString();
        }
    }

    static class NonSerializableMemoizingSupplier<T>
    implements Supplier<T> {
        volatile Supplier<T> delegate;
        volatile boolean initialized;
        T value;

        NonSerializableMemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                NonSerializableMemoizingSupplier nonSerializableMemoizingSupplier = this;
                synchronized (nonSerializableMemoizingSupplier) {
                    if (!this.initialized) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.initialized = true;
                        this.delegate = null;
                        return t2;
                    }
                }
            }
            return this.value;
        }

        public String toString() {
            Object object;
            String string;
            Supplier<T> delegate = this.delegate;
            if (delegate == null) {
                string = String.valueOf(this.value);
                object = new StringBuilder(25 + String.valueOf(string).length()).append("<supplier that returned ").append(string).append(">").toString();
            } else {
                object = delegate;
            }
            string = String.valueOf(object);
            return new StringBuilder(19 + String.valueOf(string).length()).append("Suppliers.memoize(").append(string).append(")").toString();
        }
    }

    static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.initialized = true;
                        return t2;
                    }
                }
            }
            return this.value;
        }

        public String toString() {
            Object object;
            String string;
            if (this.initialized) {
                string = String.valueOf(this.value);
                object = new StringBuilder(25 + String.valueOf(string).length()).append("<supplier that returned ").append(string).append(">").toString();
            } else {
                object = this.delegate;
            }
            string = String.valueOf(object);
            return new StringBuilder(19 + String.valueOf(string).length()).append("Suppliers.memoize(").append(string).append(")").toString();
        }
    }
}

