/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie;

import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.Cookie;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.CookieOrigin;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.CookieRestrictionViolationException;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.MalformedCookieException;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.SetCookie;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;

public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e2) {
            throw new MalformedCookieException("Invalid version: " + e2.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

