/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;

public abstract class ResolvePathsRequest<T> {
    private Path jdkHome;
    private Path mainModuleDescriptor;
    private Collection<T> pathElements;
    private Collection<String> additionalModules;
    private boolean includeAllProviders;
    private JavaModuleDescriptor resolvedMainModuleDescriptor;
    private boolean includeStatic;

    private ResolvePathsRequest() {
    }

    public static ResolvePathsRequest<Path> ofPaths(Collection<Path> paths) {
        ResolvePathsRequest<Path> request = new ResolvePathsRequest<Path>(){

            @Override
            protected Path toPath(Path t2) {
                return t2;
            }
        };
        request.pathElements = paths;
        return request;
    }

    protected abstract Path toPath(T var1);

    final ResolvePathsResult<T> createResult() {
        return new ResolvePathsResult();
    }

    public Path getMainModuleDescriptor() {
        return this.mainModuleDescriptor;
    }

    public JavaModuleDescriptor getModuleDescriptor() {
        return this.resolvedMainModuleDescriptor;
    }

    public ResolvePathsRequest<T> setModuleDescriptor(JavaModuleDescriptor mainModuleDescriptor) {
        this.resolvedMainModuleDescriptor = mainModuleDescriptor;
        return this;
    }

    public Collection<T> getPathElements() {
        return this.pathElements;
    }

    public ResolvePathsRequest<T> setJdkHome(T jdkHome) {
        this.jdkHome = this.toPath(jdkHome);
        return this;
    }

    public Path getJdkHome() {
        return this.jdkHome;
    }

    public Collection<String> getAdditionalModules() {
        if (this.additionalModules == null) {
            this.additionalModules = Collections.emptyList();
        }
        return this.additionalModules;
    }

    public boolean isIncludeAllProviders() {
        return this.includeAllProviders;
    }

    public boolean isIncludeStatic() {
        return this.includeStatic;
    }
}

