/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.JavaProjectBuilder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModule;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModuleDescriptor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

class SourceModuleInfoParser {
    SourceModuleInfoParser() {
    }

    public JavaModuleDescriptor fromSourcePath(Path modulePath) throws IOException {
        JavaModuleDescriptor.Builder builder;
        File moduleDescriptor = modulePath.toFile();
        if (moduleDescriptor.exists()) {
            com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModuleDescriptor descriptor = new JavaProjectBuilder().addSourceFolder(moduleDescriptor.getParentFile()).getDescriptor();
            builder = JavaModuleDescriptor.newModule(descriptor.getName());
            for (JavaModuleDescriptor.JavaRequires requires : descriptor.getRequires()) {
                if (requires.isStatic()) {
                    builder.requires(Collections.singleton(JavaModuleDescriptor.JavaRequires.JavaModifier.STATIC), requires.getModule().getName());
                    continue;
                }
                builder.requires(requires.getModule().getName());
            }
            for (JavaModuleDescriptor.JavaExports exports : descriptor.getExports()) {
                if (exports.getTargets().isEmpty()) {
                    builder.exports(exports.getSource().getName());
                    continue;
                }
                LinkedHashSet<String> targets = new LinkedHashSet<String>();
                for (JavaModule module : exports.getTargets()) {
                    targets.add(module.getName());
                }
                builder.exports(exports.getSource().getName(), targets);
            }
            for (JavaModuleDescriptor.JavaUses uses : descriptor.getUses()) {
                builder.uses(uses.getService().getName());
            }
            for (JavaModuleDescriptor.JavaProvides provides : descriptor.getProvides()) {
                ArrayList<String> providers = new ArrayList<String>(provides.getProviders().size());
                for (JavaClass provider : provides.getProviders()) {
                    providers.add(provider.getName());
                }
                builder.provides(provides.getService().getName(), providers);
            }
        } else {
            builder = JavaModuleDescriptor.newAutomaticModule(null);
        }
        return builder.build();
    }
}

