/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.version;

import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion
implements Comparable<JavaVersion> {
    public static final JavaVersion JAVA_SPECIFICATION_VERSION = JavaVersion.parse(System.getProperty("java.specification.version"));
    public static final JavaVersion JAVA_VERSION = JavaVersion.parse(System.getProperty("java.version"));
    private static final Pattern startingDigits = Pattern.compile("(\\d+)(.*)");
    private final String rawVersion;
    private final boolean isMajor;

    private JavaVersion(String rawVersion, boolean isMajor) {
        this.rawVersion = rawVersion;
        this.isMajor = isMajor;
    }

    public static JavaVersion parse(String s2) {
        return new JavaVersion(s2, !s2.startsWith("1."));
    }

    @Override
    public int compareTo(JavaVersion other) {
        String[] thisSegments = this.rawVersion.split("\\.");
        String[] otherSegments = other.rawVersion.split("\\.");
        int minSegments = Math.min(thisSegments.length, otherSegments.length);
        for (int index = 0; index < minSegments; ++index) {
            Matcher otherMatcher;
            int otherValue;
            Matcher thisMatcher = startingDigits.matcher(thisSegments[index]);
            int thisValue = thisMatcher.find() ? Integer.parseInt(thisMatcher.group(1)) : -1;
            int compareValue = Integer.compare(thisValue, otherValue = (otherMatcher = startingDigits.matcher(otherSegments[index])).find() ? Integer.parseInt(otherMatcher.group(1)) : -1);
            if (compareValue != 0) {
                return compareValue;
            }
            compareValue = this.suffixRate(thisMatcher.group(2)) - this.suffixRate(otherMatcher.group(2));
            if (compareValue != 0) {
                return compareValue;
            }
            compareValue = thisMatcher.group(2).compareTo(otherMatcher.group(2));
            if (compareValue == 0) continue;
            return compareValue;
        }
        return thisSegments.length - otherSegments.length;
    }

    private int suffixRate(String suffix) {
        if ("-ea".equals(suffix)) {
            return -100;
        }
        if ("".equals(suffix)) {
            return 0;
        }
        return 10;
    }

    public JavaVersion asMajor() {
        if (!this.isMajor) {
            return new JavaVersion(this.rawVersion.substring(2), true);
        }
        return this;
    }

    public String getValue(int groups) {
        StringBuilder value = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(this.rawVersion, ".");
        value.append(tokenizer.nextToken());
        for (int group = 1; group < groups; ++group) {
            value.append('.');
            if (tokenizer.hasMoreTokens()) {
                value.append(tokenizer.nextToken());
                continue;
            }
            value.append("0");
        }
        return value.toString();
    }

    public String toString() {
        return this.rawVersion;
    }

    public int hashCode() {
        return Objects.hashCode(this.rawVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaVersion other = (JavaVersion)obj;
        if (this.isMajor != other.isMajor) {
            String otherOneDotVersion;
            String thisOneDotVersion;
            if (this.isMajor) {
                thisOneDotVersion = "1." + this.rawVersion;
                otherOneDotVersion = other.rawVersion;
            } else {
                thisOneDotVersion = this.rawVersion;
                otherOneDotVersion = "1." + other.rawVersion;
            }
            if (!Objects.equals(thisOneDotVersion, otherOneDotVersion)) {
                return false;
            }
        } else if (!Objects.equals(this.rawVersion, other.rawVersion)) {
            return false;
        }
        return true;
    }
}

