/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ProtocolHandler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProtocolHandlers
implements Dumpable {
    private final Map<String, ProtocolHandler> handlers = new LinkedHashMap<String, ProtocolHandler>();

    protected ProtocolHandlers() {
    }

    public ProtocolHandler put(ProtocolHandler protocolHandler) {
        return this.handlers.put(protocolHandler.getName(), protocolHandler);
    }

    public void clear() {
        this.handlers.clear();
    }

    public ProtocolHandler find(Request request, Response response) {
        for (ProtocolHandler handler : this.handlers.values()) {
            if (!handler.accept(request, response)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.handlers);
    }
}

