/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ManagedSelector;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ProcessorUtils;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ThreadPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ThreadPoolBudget;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;

public abstract class SelectorManager
extends ContainerLifeCycle {
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private final AtomicInteger _selectorIndex = new AtomicInteger();
    private final IntUnaryOperator _selectorIndexUpdate;
    private final List<AcceptListener> _acceptListeners = new ArrayList<AcceptListener>();
    private long _connectTimeout = 15000L;
    private ThreadPoolBudget.Lease _lease;

    private static int defaultSelectors(Executor executor) {
        if (executor instanceof ThreadPool.SizedThreadPool) {
            int threads = ((ThreadPool.SizedThreadPool)executor).getMaxThreads();
            int cpus = ProcessorUtils.availableProcessors();
            return Math.max(1, Math.min(cpus / 2, threads / 16));
        }
        return Math.max(1, ProcessorUtils.availableProcessors() / 2);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        if (selectors <= 0) {
            selectors = SelectorManager.defaultSelectors(executor);
        }
        this.executor = executor;
        this.scheduler = scheduler;
        this._selectors = new ManagedSelector[selectors];
        this._selectorIndexUpdate = index -> (index + 1) % this._selectors.length;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long milliseconds) {
        this._connectTimeout = milliseconds;
    }

    protected void execute(Runnable task) {
        this.executor.execute(task);
    }

    private ManagedSelector chooseSelector() {
        return this._selectors[this._selectorIndex.updateAndGet(this._selectorIndexUpdate)];
    }

    public void connect(SelectableChannel channel, Object attachment) {
        ManagedSelector set;
        ManagedSelector managedSelector = set = this.chooseSelector();
        Objects.requireNonNull(managedSelector);
        set.submit(managedSelector.new ManagedSelector.Connect(channel, attachment));
    }

    public void accept(SelectableChannel channel, Object attachment) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector();
        Objects.requireNonNull(managedSelector);
        selector.submit(managedSelector.new ManagedSelector.Accept(channel, attachment));
    }

    @Override
    protected void doStart() throws Exception {
        this._lease = ThreadPoolBudget.leaseFrom(this.getExecutor(), this, this._selectors.length);
        for (int i2 = 0; i2 < this._selectors.length; ++i2) {
            ManagedSelector selector;
            this._selectors[i2] = selector = this.newSelector(i2);
            this.addBean(selector);
        }
        super.doStart();
    }

    protected ManagedSelector newSelector(int id) {
        return new ManagedSelector(this, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            for (ManagedSelector selector : this._selectors) {
                if (selector == null) continue;
                this.removeBean(selector);
            }
            Arrays.fill(this._selectors, null);
            if (this._lease != null) {
                this._lease.close();
            }
        }
    }

    protected void endPointOpened(EndPoint endpoint) {
    }

    protected void endPointClosed(EndPoint endpoint) {
    }

    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
        }
        catch (Throwable x2) {
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, x2);
            } else {
                LOG.debug("Exception while notifying connection " + connection, x2);
            }
            throw x2;
        }
    }

    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
        }
        catch (Throwable x2) {
            LOG.debug("Exception while notifying connection " + connection, x2);
        }
    }

    protected boolean doFinishConnect(SelectableChannel channel) throws IOException {
        return ((SocketChannel)channel).finishConnect();
    }

    protected boolean isConnectionPending(SelectableChannel channel) {
        return ((SocketChannel)channel).isConnectionPending();
    }

    protected void connectionFailed(SelectableChannel channel, Throwable ex, Object attachment) {
        LOG.warn(String.format("%s - %s", channel, attachment), ex);
    }

    protected Selector newSelector() throws IOException {
        return Selector.open();
    }

    protected abstract EndPoint newEndPoint(SelectableChannel var1, ManagedSelector var2, SelectionKey var3) throws IOException;

    public abstract Connection newConnection(SelectableChannel var1, EndPoint var2, Object var3) throws IOException;

    protected void onAccepting(SelectableChannel channel) {
        for (AcceptListener l2 : this._acceptListeners) {
            try {
                l2.onAccepting(channel);
            }
            catch (Throwable x2) {
                LOG.warn(x2);
            }
        }
    }

    protected void onAcceptFailed(SelectableChannel channel, Throwable cause) {
        for (AcceptListener l2 : this._acceptListeners) {
            try {
                l2.onAcceptFailed(channel, cause);
            }
            catch (Throwable x2) {
                LOG.warn(x2);
            }
        }
    }

    protected void onAccepted(SelectableChannel channel) {
        for (AcceptListener l2 : this._acceptListeners) {
            try {
                l2.onAccepted(channel);
            }
            catch (Throwable x2) {
                LOG.warn(x2);
            }
        }
    }

    public static interface AcceptListener
    extends EventListener {
        default public void onAccepting(SelectableChannel channel) {
        }

        default public void onAcceptFailed(SelectableChannel channel, Throwable cause) {
        }

        default public void onAccepted(SelectableChannel channel) {
        }
    }
}

