/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.MultiMap;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Utf8Appendable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Utf8StringBuffer;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Utf8StringBuilder;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UrlEncoded
extends MultiMap<String>
implements Cloneable {
    static final Logger LOG;
    public static final Charset ENCODING;

    public UrlEncoded(UrlEncoded url) {
        super(url);
    }

    public UrlEncoded() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap<String> map, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(content, 0, content.length(), map);
            return;
        }
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            String value;
            String key = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i2 = 0; i2 < content.length(); ++i2) {
                char c2 = content.charAt(i2);
                switch (c2) {
                    case '&': {
                        int l2 = i2 - mark - 1;
                        value = l2 == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l2, charset) : content.substring(mark + 1, i2));
                        mark = i2;
                        encoded = false;
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) continue block9;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i2 - mark - 1, charset) : content.substring(mark + 1, i2);
                        mark = i2;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key != null) {
                int l3 = content.length() - mark - 1;
                value = l3 == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l3, charset) : content.substring(mark + 1));
                map.add(key, value);
            } else if (mark < content.length()) {
                String string = key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                if (key != null && key.length() > 0) {
                    map.add(key, "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(String query, int offset, int length, MultiMap<String> map) {
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int end = offset + length;
            block9: for (int i2 = offset; i2 < end; ++i2) {
                char c2 = query.charAt(i2);
                switch (c2) {
                    case '&': {
                        value = buffer.toReplacedString();
                        buffer.reset();
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append(c2);
                            continue block9;
                        }
                        key = buffer.toReplacedString();
                        buffer.reset();
                        continue block9;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        continue block9;
                    }
                    case '%': {
                        if (i2 + 2 < end) {
                            char hi = query.charAt(++i2);
                            char lo = query.charAt(++i2);
                            buffer.append(UrlEncoded.decodeHexByte(hi, lo));
                            continue block9;
                        }
                        throw new Utf8Appendable.NotUtf8Exception("Incomplete % encoding");
                    }
                    default: {
                        buffer.append(c2);
                    }
                }
            }
            if (key != null) {
                value = buffer.toReplacedString();
                buffer.reset();
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toReplacedString(), "");
            }
        }
    }

    public static String decodeString(String encoded, int offset, int length, Charset charset) {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8Appendable buffer = null;
            for (int i2 = 0; i2 < length; ++i2) {
                char c2 = encoded.charAt(offset + i2);
                if (c2 < '\u0000' || c2 > '\u00ff') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i2 + 1);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(c2);
                    continue;
                }
                if (c2 == '+') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i2);
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(' ');
                    continue;
                }
                if (c2 == '%') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i2);
                    }
                    if (i2 + 2 < length) {
                        int o2 = offset + i2 + 1;
                        i2 += 2;
                        byte b2 = (byte)TypeUtil.parseInt(encoded, o2, 2, 16);
                        buffer.append(b2);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                    i2 = length;
                    continue;
                }
                if (buffer == null) continue;
                ((Utf8StringBuffer)buffer).getStringBuffer().append(c2);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toReplacedString();
        }
        StringBuffer buffer = null;
        for (int i3 = 0; i3 < length; ++i3) {
            char c3 = encoded.charAt(offset + i3);
            if (c3 < '\u0000' || c3 > '\u00ff') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i3 + 1);
                    continue;
                }
                buffer.append(c3);
                continue;
            }
            if (c3 == '+') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i3);
                }
                buffer.append(' ');
                continue;
            }
            if (c3 == '%') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i3);
                }
                byte[] ba2 = new byte[length];
                int n2 = 0;
                while (c3 >= '\u0000' && c3 <= '\u00ff') {
                    if (c3 == '%') {
                        if (i3 + 2 < length) {
                            int o3 = offset + i3 + 1;
                            i3 += 3;
                            ba2[n2] = (byte)TypeUtil.parseInt(encoded, o3, 2, 16);
                            ++n2;
                        } else {
                            ba2[n2++] = 63;
                            i3 = length;
                        }
                    } else if (c3 == '+') {
                        ba2[n2++] = 32;
                        ++i3;
                    } else {
                        ba2[n2++] = (byte)c3;
                        ++i3;
                    }
                    if (i3 >= length) break;
                    c3 = encoded.charAt(offset + i3);
                }
                --i3;
                buffer.append(new String(ba2, 0, n2, charset));
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c3);
        }
        if (buffer == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        return buffer.toString();
    }

    private static byte decodeHexByte(char hi, char lo) {
        try {
            return (byte)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException("Not valid encoding '%" + hi + lo + "'");
        }
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }

    static {
        Charset encoding;
        LOG = Log.getLogger(UrlEncoded.class);
        try {
            String charset = System.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.UrlEncoding.charset");
            encoding = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
        }
        catch (Exception e2) {
            LOG.warn(e2);
            encoding = StandardCharsets.UTF_8;
        }
        ENCODING = encoding;
    }
}

