/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.resource;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.IO;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.resource.URLResource;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;

public class JarResource
extends URLResource {
    private static final Logger LOG = Log.getLogger(JarResource.class);
    protected JarURLConnection _jarConnection;

    protected JarResource(URL url, boolean useCaches) {
        super(url, null, useCaches);
    }

    @Override
    public synchronized void close() {
        this._jarConnection = null;
        super.close();
    }

    @Override
    protected synchronized boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException e2) {
            LOG.ignore(e2);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() throws IOException {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    @Override
    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkConnection();
        if (!this._urlString.endsWith("!/")) {
            return new FilterInputStream(this.getInputStream(false)){

                @Override
                public void close() {
                    this.in = IO.getClosedStream();
                }
            };
        }
        URL url = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        InputStream is = url.openStream();
        return is;
    }
}

