/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Operation;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.OperatorOverloader;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeComparator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParserConfiguration;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.CollectionUtils;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class ExpressionState {
    private final EvaluationContext relatedContext;
    private final TypedValue rootObject;
    private final SpelParserConfiguration configuration;
    private Deque<TypedValue> contextObjects;
    private Deque<VariableScope> variableScopes;
    private ArrayDeque<TypedValue> scopeRootObjects;

    public ExpressionState(EvaluationContext context, TypedValue rootObject, SpelParserConfiguration configuration) {
        Assert.notNull((Object)context, "EvaluationContext must not be null");
        Assert.notNull((Object)configuration, "SpelParserConfiguration must not be null");
        this.relatedContext = context;
        this.rootObject = rootObject;
        this.configuration = configuration;
    }

    public TypedValue getActiveContextObject() {
        if (CollectionUtils.isEmpty(this.contextObjects)) {
            return this.rootObject;
        }
        return this.contextObjects.element();
    }

    public void pushActiveContextObject(TypedValue obj) {
        if (this.contextObjects == null) {
            this.contextObjects = new ArrayDeque<TypedValue>();
        }
        this.contextObjects.push(obj);
    }

    public void popActiveContextObject() {
        if (this.contextObjects == null) {
            this.contextObjects = new ArrayDeque<TypedValue>();
        }
        try {
            this.contextObjects.pop();
        }
        catch (NoSuchElementException ex) {
            throw new IllegalStateException("Cannot pop active context object: stack is empty");
        }
    }

    public TypedValue getRootContextObject() {
        return this.rootObject;
    }

    public TypedValue getScopeRootContextObject() {
        if (CollectionUtils.isEmpty(this.scopeRootObjects)) {
            return this.rootObject;
        }
        return this.scopeRootObjects.element();
    }

    public void setVariable(String name, Object value) {
        this.relatedContext.setVariable(name, value);
    }

    public TypedValue lookupVariable(String name) {
        Object value = this.relatedContext.lookupVariable(name);
        return value != null ? new TypedValue(value) : TypedValue.NULL;
    }

    public TypeComparator getTypeComparator() {
        return this.relatedContext.getTypeComparator();
    }

    public Class<?> findType(String type) throws EvaluationException {
        return this.relatedContext.getTypeLocator().findType(type);
    }

    public Object convertValue(Object value, TypeDescriptor targetTypeDescriptor) throws EvaluationException {
        Object result = this.relatedContext.getTypeConverter().convertValue(value, TypeDescriptor.forObject(value), targetTypeDescriptor);
        if (result == null) {
            throw new IllegalStateException("Null conversion result for value [" + value + "]");
        }
        return result;
    }

    public TypeConverter getTypeConverter() {
        return this.relatedContext.getTypeConverter();
    }

    public void enterScope() {
        this.initVariableScopes().push(new VariableScope(Collections.emptyMap()));
        this.initScopeRootObjects().push(this.getActiveContextObject());
    }

    public void enterScope(String name, Object value) {
        this.initVariableScopes().push(new VariableScope(name, value));
        this.initScopeRootObjects().push(this.getActiveContextObject());
    }

    public void exitScope() {
        this.initVariableScopes().pop();
        this.initScopeRootObjects().pop();
    }

    private Deque<VariableScope> initVariableScopes() {
        if (this.variableScopes == null) {
            this.variableScopes = new ArrayDeque<VariableScope>();
            this.variableScopes.add(new VariableScope());
        }
        return this.variableScopes;
    }

    private Deque<TypedValue> initScopeRootObjects() {
        if (this.scopeRootObjects == null) {
            this.scopeRootObjects = new ArrayDeque();
        }
        return this.scopeRootObjects;
    }

    public TypedValue operate(Operation op, Object left, Object right) throws EvaluationException {
        OperatorOverloader overloader = this.relatedContext.getOperatorOverloader();
        if (overloader.overridesOperation(op, left, right)) {
            Object returnValue = overloader.operate(op, left, right);
            return new TypedValue(returnValue);
        }
        String leftType = left == null ? "null" : left.getClass().getName();
        String rightType = right == null ? "null" : right.getClass().getName();
        throw new SpelEvaluationException(SpelMessage.OPERATOR_NOT_SUPPORTED_BETWEEN_TYPES, new Object[]{op, leftType, rightType});
    }

    public EvaluationContext getEvaluationContext() {
        return this.relatedContext;
    }

    public SpelParserConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class VariableScope {
        private final Map<String, Object> vars = new HashMap<String, Object>();

        public VariableScope() {
        }

        public VariableScope(Map<String, Object> arguments) {
            if (arguments != null) {
                this.vars.putAll(arguments);
            }
        }

        public VariableScope(String name, Object value) {
            this.vars.put(name, value);
        }
    }
}

