/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.InternalParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.FloatLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.IntLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.LongLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.RealLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;

public abstract class Literal
extends SpelNodeImpl {
    private final String originalValue;

    public Literal(String originalValue, int startPos, int endPos) {
        super(startPos, endPos, new SpelNodeImpl[0]);
        this.originalValue = originalValue;
    }

    @Override
    public final TypedValue getValueInternal(ExpressionState state) throws SpelEvaluationException {
        return this.getLiteralValue();
    }

    public String toString() {
        return String.valueOf(this.getLiteralValue().getValue());
    }

    @Override
    public String toStringAST() {
        return this.toString();
    }

    public abstract TypedValue getLiteralValue();

    public static Literal getIntLiteral(String numberToken, int startPos, int endPos, int radix) {
        try {
            int value = Integer.parseInt(numberToken, radix);
            return new IntLiteral(numberToken, startPos, endPos, value);
        }
        catch (NumberFormatException ex) {
            throw new InternalParseException(new SpelParseException(startPos, (Throwable)ex, SpelMessage.NOT_AN_INTEGER, numberToken));
        }
    }

    public static Literal getLongLiteral(String numberToken, int startPos, int endPos, int radix) {
        try {
            long value = Long.parseLong(numberToken, radix);
            return new LongLiteral(numberToken, startPos, endPos, value);
        }
        catch (NumberFormatException ex) {
            throw new InternalParseException(new SpelParseException(startPos, (Throwable)ex, SpelMessage.NOT_A_LONG, numberToken));
        }
    }

    public static Literal getRealLiteral(String numberToken, int startPos, int endPos, boolean isFloat) {
        try {
            if (isFloat) {
                float value = Float.parseFloat(numberToken);
                return new FloatLiteral(numberToken, startPos, endPos, value);
            }
            double value = Double.parseDouble(numberToken);
            return new RealLiteral(numberToken, startPos, endPos, value);
        }
        catch (NumberFormatException ex) {
            throw new InternalParseException(new SpelParseException(startPos, (Throwable)ex, SpelMessage.NOT_A_REAL, numberToken));
        }
    }
}

