/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.scan.extension.test.event.internal;

import com.gradle.maven.scan.extension.test.event.internal.TestExceptionData;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class ThrowableConverter {
    public static TestExceptionData convert(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        String className = throwable.getClass().getName();
        String message = throwable.getMessage();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        List classLevelAnnotations = Arrays.stream(throwable.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getName).collect(Collectors.toCollection(ArrayList::new));
        TestExceptionData cause = ThrowableConverter.convert(throwable.getCause());
        List suppressed = Arrays.stream(throwable.getSuppressed()).map(ThrowableConverter::convert).collect(Collectors.toCollection(ArrayList::new));
        return new TestExceptionData(className, classLevelAnnotations, message, stackTrace, cause, suppressed);
    }

    private ThrowableConverter() {
    }
}

