/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.testdistribution.extension;

import com.gradle.maven.common.configuration.ab;
import com.gradle.maven.common.configuration.b;
import com.gradle.maven.common.configuration.g;
import com.gradle.maven.common.configuration.w;
import com.gradle.maven.common.configuration.x;
import com.gradle.maven.common.d.a;
import com.gradle.maven.testdistribution.extension.ImmutableTestDistributionGoalConfiguration;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.immutables.value.Value;

@Value.Immutable(builder=true)
public interface TestDistributionGoalConfiguration {
    public static final com.gradle.enterprise.version.b MINIMUM_SUREFIRE_VERSION = com.gradle.enterprise.version.b.a("2.22").i();

    public boolean enabled();

    public Integer getMaxLocalExecutors();

    public Integer getMaxRemoteExecutors();

    public Boolean getRemoteExecutionPreferred();

    public Long getPreferredMaxDurationInMillis();

    public Set<String> getRequirements();

    public Integer getWaitTimeoutInSeconds();

    public Integer getForkedVMShutdownTimeoutInSeconds();

    public static boolean isSupportedGoalAndVersion(MojoExecution execution) {
        return TestDistributionGoalConfiguration.isSupportedGoal(execution) && TestDistributionGoalConfiguration.isSupportedVersion(execution);
    }

    public static boolean isSupportedGoal(MojoExecution execution) {
        String artifactId = execution.getArtifactId();
        return TestDistributionGoalConfiguration.isSurefire(execution, artifactId) || TestDistributionGoalConfiguration.isFailsafe(execution, artifactId);
    }

    public static boolean isSupportedVersion(MojoExecution execution) {
        com.gradle.enterprise.version.b version = com.gradle.enterprise.version.b.a(execution.getVersion());
        return version.a(MINIMUM_SUREFIRE_VERSION);
    }

    public static boolean isSurefire(MojoExecution execution, String artifactId) {
        return artifactId.equals("maven-surefire-plugin") && execution.getGoal().equals("test");
    }

    public static boolean isFailsafe(MojoExecution execution, String artifactId) {
        return artifactId.equals("maven-failsafe-plugin") && execution.getGoal().equals("integration-test");
    }

    public static TestDistributionGoalConfiguration from(a execution) {
        g evaluationContext = g.a(execution.c(), execution.a());
        x<?> expressionEvaluator = x.a(evaluationContext);
        b configurator = b.a();
        w systemPropertyEvaluator = new w(configurator.b(), (ExpressionEvaluator)expressionEvaluator, evaluationContext);
        ImmutableTestDistributionGoalConfiguration.Builder configuration = ImmutableTestDistributionGoalConfiguration.builder().setEnabled(false);
        TestDistributionGoalConfiguration.configureFromPom(configuration, execution, configurator, expressionEvaluator);
        TestDistributionGoalConfiguration.configureFromProperties(configuration, systemPropertyEvaluator);
        return configuration.build();
    }

    public static void configureFromPom(ImmutableTestDistributionGoalConfiguration.Builder configuration, a execution, b configurator, ExpressionEvaluator expressionEvaluator) {
        Optional.ofNullable(execution.b()).map(MojoExecution::getConfiguration).map(it -> it.getChild("properties")).map(it -> it.getChild("distribution")).map(XmlPlexusConfiguration::new).ifPresent(plexusConfiguration -> {
            try {
                configurator.configureComponent(configuration, (PlexusConfiguration)plexusConfiguration, expressionEvaluator, null);
            }
            catch (ComponentConfigurationException e2) {
                throw new RuntimeException("Could not evaluate Gradle Enterprise test distribution configuration", e2);
            }
        });
    }

    public static void configureFromProperties(ImmutableTestDistributionGoalConfiguration.Builder conf, ab evaluator) {
        evaluator.a("gradle.testdistribution.enabled", Boolean.class, conf::setEnabled);
        evaluator.a("gradle.testdistribution.maxLocalExecutors", Integer.class, conf::setMaxLocalExecutors);
        evaluator.a("gradle.testdistribution.maxRemoteExecutors", Integer.class, conf::setMaxRemoteExecutors);
        evaluator.a("gradle.testdistribution.waitTimeoutInSeconds", Integer.class, conf::setWaitTimeoutInSeconds);
        evaluator.a("gradle.internal.testdistribution.preferredMaxDurationInMillis", Long.class, conf::setPreferredMaxDurationInMillis);
    }
}

