/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.BaseImmutableMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableListMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Platform;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public abstract class ImmutableMultimap<K, V>
extends BaseImmutableMultimap<K, V>
implements Serializable {
    final transient ImmutableMap<K, ? extends ImmutableCollection<V>> map;
    final transient int size;

    public static <K, V> ImmutableMultimap<K, V> of() {
        return ImmutableListMultimap.of();
    }

    ImmutableMultimap(ImmutableMap<K, ? extends ImmutableCollection<V>> map, int size) {
        this.map = map;
        this.size = size;
    }

    boolean isPartialView() {
        return this.map.isPartialView();
    }

    public int size() {
        return this.size;
    }

    @Override
    public ImmutableMap<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableCollection<Map.Entry<K, V>> entries() {
        return (ImmutableCollection)super.entries();
    }

    @Override
    ImmutableCollection<Map.Entry<K, V>> createEntries() {
        return new EntryCollection(this);
    }

    UnmodifiableIterator<Map.Entry<K, V>> entryIterator() {
        return new UnmodifiableIterator<Map.Entry<K, V>>(){
            final Iterator<? extends Map.Entry<K, ? extends ImmutableCollection<V>>> asMapItr;
            K currentKey;
            Iterator<V> valueItr;
            {
                this.asMapItr = ((ImmutableSet)ImmutableMultimap.this.map.entrySet()).iterator();
                this.currentKey = null;
                this.valueItr = Iterators.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                return this.valueItr.hasNext() || this.asMapItr.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.valueItr.hasNext()) {
                    Map.Entry entry = this.asMapItr.next();
                    this.currentKey = entry.getKey();
                    this.valueItr = entry.getValue().iterator();
                }
                return Maps.immutableEntry(this.currentKey, this.valueItr.next());
            }
        };
    }

    private static class EntryCollection<K, V>
    extends ImmutableCollection<Map.Entry<K, V>> {
        final ImmutableMultimap<K, V> multimap;

        EntryCollection(ImmutableMultimap<K, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.multimap.entryIterator();
        }

        @Override
        boolean isPartialView() {
            return this.multimap.isPartialView();
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.multimap.containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }
    }

    public static class Builder<K, V> {
        Map<K, Collection<V>> builderMap = Platform.preservesInsertionOrderOnPutsMap();
        Comparator<? super K> keyComparator;
        Comparator<? super V> valueComparator;

        Collection<V> newMutableValueCollection() {
            return new ArrayList();
        }

        public Builder<K, V> put(K key, V value) {
            CollectPreconditions.checkEntryNotNull(key, value);
            Collection<V> valueCollection = this.builderMap.get(key);
            if (valueCollection == null) {
                valueCollection = this.newMutableValueCollection();
                this.builderMap.put(key, valueCollection);
            }
            valueCollection.add(value);
            return this;
        }

        public ImmutableMultimap<K, V> build() {
            Collection<Map.Entry<K, Collection<V>>> mapEntries = this.builderMap.entrySet();
            if (this.keyComparator != null) {
                mapEntries = Ordering.from(this.keyComparator).onKeys().immutableSortedCopy(mapEntries);
            }
            return ImmutableListMultimap.fromMapEntries(mapEntries, this.valueComparator);
        }
    }
}

