/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.math;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.math.MathPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.Ints;
import java.math.RoundingMode;

public final class IntMath {
    static final byte[] maxLog10ForLeadingZeros = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    static final int[] powersOf10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    static final int[] halfPowersOf10 = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    private static final int[] factorials = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    static int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};

    public static boolean isPowerOfTwo(int x2) {
        return x2 > 0 & (x2 & x2 - 1) == 0;
    }

    static int lessThanBranchFree(int x2, int y2) {
        return ~(~(x2 - y2)) >>> 31;
    }

    public static int log2(int x2, RoundingMode mode) {
        MathPreconditions.checkPositive("x", x2);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(IntMath.isPowerOfTwo(x2));
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(x2);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(x2 - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Integer.numberOfLeadingZeros(x2);
                int cmp = -1257966797 >>> leadingZeros;
                int logFloor = 31 - leadingZeros;
                return logFloor + IntMath.lessThanBranchFree(cmp, x2);
            }
        }
        throw new AssertionError();
    }

    public static int sqrt(int x2, RoundingMode mode) {
        MathPreconditions.checkNonNegative("x", x2);
        int sqrtFloor = IntMath.sqrtFloor(x2);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(sqrtFloor * sqrtFloor == x2);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                return sqrtFloor + IntMath.lessThanBranchFree(sqrtFloor * sqrtFloor, x2);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return sqrtFloor + IntMath.lessThanBranchFree(halfSquare, x2);
            }
        }
        throw new AssertionError();
    }

    private static int sqrtFloor(int x2) {
        return (int)Math.sqrt(x2);
    }

    public static int divide(int p2, int q2, RoundingMode mode) {
        boolean increment;
        Preconditions.checkNotNull(mode);
        if (q2 == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int div = p2 / q2;
        int rem = p2 - q2 * div;
        if (rem == 0) {
            return div;
        }
        int signum = 1 | (p2 ^ q2) >> 31;
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(rem == 0);
            }
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int absRem = Math.abs(rem);
                int cmpRemToHalfDivisor = absRem - (Math.abs(q2) - absRem);
                if (cmpRemToHalfDivisor == 0) {
                    increment = mode == RoundingMode.HALF_UP || mode == RoundingMode.HALF_EVEN & (div & 1) != 0;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + signum : div;
    }

    public static int saturatedMultiply(int a2, int b2) {
        return Ints.saturatedCast((long)a2 * (long)b2);
    }

    public static int binomial(int n2, int k2) {
        MathPreconditions.checkNonNegative("n", n2);
        MathPreconditions.checkNonNegative("k", k2);
        Preconditions.checkArgument(k2 <= n2, "k (%s) > n (%s)", k2, n2);
        if (k2 > n2 >> 1) {
            k2 = n2 - k2;
        }
        if (k2 >= biggestBinomials.length || n2 > biggestBinomials[k2]) {
            return Integer.MAX_VALUE;
        }
        switch (k2) {
            case 0: {
                return 1;
            }
            case 1: {
                return n2;
            }
        }
        long result = 1L;
        for (int i2 = 0; i2 < k2; ++i2) {
            result *= (long)(n2 - i2);
            result /= (long)(i2 + 1);
        }
        return (int)result;
    }
}

