/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.jodah.failsafe;

import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.ExecutionResult;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.FailsafeExecutor;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.Policy;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.PolicyExecutor;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.internal.util.Assert;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.util.concurrent.Scheduler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractExecution
extends ExecutionContext {
    final Scheduler scheduler;
    final FailsafeExecutor<Object> executor;
    final List<PolicyExecutor<Policy<Object>>> policyExecutors;
    volatile boolean resultHandled;
    volatile boolean canInterrupt;
    volatile boolean interrupted;
    volatile boolean completed;

    AbstractExecution(Scheduler scheduler, FailsafeExecutor<Object> executor) {
        this.scheduler = scheduler;
        this.executor = executor;
        this.policyExecutors = new ArrayList<PolicyExecutor<Policy<Object>>>(executor.policies.size());
        ListIterator policyIterator = executor.policies.listIterator(executor.policies.size());
        while (policyIterator.hasPrevious()) {
            this.policyExecutors.add(policyIterator.previous().toExecutor(this));
        }
    }

    void record(ExecutionResult result) {
        Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
        if (!this.interrupted) {
            this.attempts.incrementAndGet();
            this.lastResult = result.getResult();
            this.lastFailure = result.getFailure();
        }
    }

    void preExecute() {
        this.attemptStartTime = Duration.ofNanos(System.nanoTime());
        if (this.startTime == Duration.ZERO) {
            this.startTime = this.attemptStartTime;
        }
        this.resultHandled = false;
        this.cancelled = false;
        this.canInterrupt = true;
        this.interrupted = false;
    }
}

