/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jdk14.JDK14Util;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class DefaultAccessorNamingStrategy
extends AccessorNamingStrategy {
    protected final MapperConfig<?> _config;
    protected final AnnotatedClass _forClass;
    protected final BaseNameValidator _baseNameValidator;
    protected final boolean _stdBeanNaming;
    protected final String _getterPrefix;
    protected final String _isGetterPrefix;
    protected final String _mutatorPrefix;

    protected DefaultAccessorNamingStrategy(MapperConfig<?> config, AnnotatedClass forClass, String mutatorPrefix, String getterPrefix, String isGetterPrefix, BaseNameValidator baseNameValidator) {
        this._config = config;
        this._forClass = forClass;
        this._stdBeanNaming = config.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
        this._mutatorPrefix = mutatorPrefix;
        this._getterPrefix = getterPrefix;
        this._isGetterPrefix = isGetterPrefix;
        this._baseNameValidator = baseNameValidator;
    }

    @Override
    public String findNameForIsGetter(AnnotatedMethod am2, String name) {
        Class<?> rt;
        if (this._isGetterPrefix != null && ((rt = am2.getRawType()) == Boolean.class || rt == Boolean.TYPE) && name.startsWith(this._isGetterPrefix)) {
            return this._stdBeanNaming ? this.stdManglePropertyName(name, 2) : this.legacyManglePropertyName(name, 2);
        }
        return null;
    }

    @Override
    public String findNameForRegularGetter(AnnotatedMethod am2, String name) {
        if (this._getterPrefix != null && name.startsWith(this._getterPrefix)) {
            if ("getCallbacks".equals(name) ? this._isCglibGetCallbacks(am2) : "getMetaClass".equals(name) && this._isGroovyMetaClassGetter(am2)) {
                return null;
            }
            return this._stdBeanNaming ? this.stdManglePropertyName(name, this._getterPrefix.length()) : this.legacyManglePropertyName(name, this._getterPrefix.length());
        }
        return null;
    }

    @Override
    public String findNameForMutator(AnnotatedMethod am2, String name) {
        if (this._mutatorPrefix != null && name.startsWith(this._mutatorPrefix)) {
            return this._stdBeanNaming ? this.stdManglePropertyName(name, this._mutatorPrefix.length()) : this.legacyManglePropertyName(name, this._mutatorPrefix.length());
        }
        return null;
    }

    @Override
    public String modifyFieldName(AnnotatedField field, String name) {
        return name;
    }

    protected String legacyManglePropertyName(String basename, int offset) {
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c2 = basename.charAt(offset);
        if (this._baseNameValidator != null && !this._baseNameValidator.accept(c2, basename, offset)) {
            return null;
        }
        char d2 = Character.toLowerCase(c2);
        if (c2 == d2) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(d2);
        for (int i2 = offset + 1; i2 < end; ++i2) {
            c2 = basename.charAt(i2);
            if (c2 == (d2 = Character.toLowerCase(c2))) {
                sb.append(basename, i2, end);
                break;
            }
            sb.append(d2);
        }
        return sb.toString();
    }

    protected String stdManglePropertyName(String basename, int offset) {
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c0 = basename.charAt(offset);
        if (this._baseNameValidator != null && !this._baseNameValidator.accept(c0, basename, offset)) {
            return null;
        }
        char c1 = Character.toLowerCase(c0);
        if (c0 == c1) {
            return basename.substring(offset);
        }
        if (offset + 1 < end && Character.isUpperCase(basename.charAt(offset + 1))) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(c1);
        sb.append(basename, offset + 1, end);
        return sb.toString();
    }

    protected boolean _isCglibGetCallbacks(AnnotatedMethod am2) {
        Class<?> compType;
        String className;
        Class<?> rt = am2.getRawType();
        if (rt.isArray() && (className = (compType = rt.getComponentType()).getName()).contains(".cglib")) {
            return className.startsWith("net.sf.cglib") || className.startsWith("org.hibernate.repackage.cglib") || className.startsWith("com.gradle.maven.extension.internal.dep.org.springframework.cglib");
        }
        return false;
    }

    protected boolean _isGroovyMetaClassGetter(AnnotatedMethod am2) {
        return am2.getRawType().getName().startsWith("groovy.lang");
    }

    public static class RecordNaming
    extends DefaultAccessorNamingStrategy {
        protected final Set<String> _fieldNames = new HashSet<String>();

        public RecordNaming(MapperConfig<?> config, AnnotatedClass forClass) {
            super(config, forClass, null, "get", "is", null);
            for (String name : JDK14Util.getRecordFieldNames(forClass.getRawType())) {
                this._fieldNames.add(name);
            }
        }

        @Override
        public String findNameForRegularGetter(AnnotatedMethod am2, String name) {
            if (this._fieldNames.contains(name)) {
                return name;
            }
            return super.findNameForRegularGetter(am2, name);
        }
    }

    public static class Provider
    extends AccessorNamingStrategy.Provider
    implements Serializable {
        protected final String _setterPrefix;
        protected final String _withPrefix;
        protected final String _getterPrefix;
        protected final String _isGetterPrefix;
        protected final BaseNameValidator _baseNameValidator;

        public Provider() {
            this("set", "with", "get", "is", null);
        }

        protected Provider(String setterPrefix, String withPrefix, String getterPrefix, String isGetterPrefix, BaseNameValidator vld) {
            this._setterPrefix = setterPrefix;
            this._withPrefix = withPrefix;
            this._getterPrefix = getterPrefix;
            this._isGetterPrefix = isGetterPrefix;
            this._baseNameValidator = vld;
        }

        @Override
        public AccessorNamingStrategy forPOJO(MapperConfig<?> config, AnnotatedClass targetClass) {
            return new DefaultAccessorNamingStrategy(config, targetClass, this._setterPrefix, this._getterPrefix, this._isGetterPrefix, this._baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forBuilder(MapperConfig<?> config, AnnotatedClass builderClass, BeanDescription valueTypeDesc) {
            AnnotationIntrospector ai2 = config.isAnnotationProcessingEnabled() ? config.getAnnotationIntrospector() : null;
            JsonPOJOBuilder.Value builderConfig = ai2 == null ? null : ai2.findPOJOBuilderConfig(builderClass);
            String mutatorPrefix = builderConfig == null ? this._withPrefix : builderConfig.withPrefix;
            return new DefaultAccessorNamingStrategy(config, builderClass, mutatorPrefix, this._getterPrefix, this._isGetterPrefix, this._baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forRecord(MapperConfig<?> config, AnnotatedClass recordClass) {
            return new RecordNaming(config, recordClass);
        }
    }

    public static interface BaseNameValidator {
        public boolean accept(char var1, String var2, int var3);
    }
}

