/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.Builder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.ClassDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.FieldDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.MethodDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.PackageDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.TypeDef;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.StringTokenizer;

public class BinaryClassParser {
    private Class<?> declaringClazz;
    private Builder binaryBuilder;

    public BinaryClassParser(Class<?> declaringClazz, Builder modelBuilder) {
        this.declaringClazz = declaringClazz;
        this.binaryBuilder = modelBuilder;
    }

    public boolean parse() {
        try {
            if (this.declaringClazz.getPackage() != null && !"".equals(this.declaringClazz.getPackage().getName())) {
                this.binaryBuilder.addPackage(new PackageDef(this.declaringClazz.getPackage().getName()));
            }
            this.addClass(this.declaringClazz);
            return true;
        }
        catch (NoClassDefFoundError e2) {
            return false;
        }
    }

    private void addClass(Class<?> clazz) {
        Class<?> anInterface;
        ClassDef classDef = new ClassDef(clazz.getSimpleName());
        Class<?>[] interfaces = clazz.getInterfaces();
        if (clazz.isEnum()) {
            classDef.setType("enum");
        } else if (clazz.isAnnotation()) {
            classDef.setType("@interface");
        } else if (clazz.isInterface()) {
            classDef.setType("interface");
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                anInterface = interfaces[i2];
                classDef.getExtends().add(new TypeDef(anInterface.getName()));
            }
        } else {
            for (int i3 = 0; i3 < interfaces.length; ++i3) {
                anInterface = interfaces[i3];
                classDef.getImplements().add(new TypeDef(anInterface.getName()));
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                classDef.getExtends().add(new TypeDef(superclass.getName()));
            }
        }
        BinaryClassParser.addModifiers(classDef.getModifiers(), clazz.getModifiers());
        this.binaryBuilder.beginClass(classDef);
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i4 = 0; i4 < constructors.length; ++i4) {
            this.binaryBuilder.beginConstructor();
            MethodDef methodDef = this.createMethodDef(constructors[i4]);
            this.binaryBuilder.endConstructor(methodDef);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i5 = 0; i5 < methods.length; ++i5) {
            this.binaryBuilder.beginMethod();
            MethodDef methodDef = this.createMethodDef(methods[i5]);
            this.binaryBuilder.endMethod(methodDef);
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i6 = 0; i6 < fields.length; ++i6) {
            this.addField(fields[i6]);
        }
        Class<?>[] classes = clazz.getDeclaredClasses();
        for (int i7 = 0; i7 < classes.length; ++i7) {
            this.addClass(classes[i7]);
        }
        this.binaryBuilder.endClass();
    }

    private static void addModifiers(Set<String> set, int modifier) {
        String modifierString = Modifier.toString(modifier);
        StringTokenizer stringTokenizer = new StringTokenizer(modifierString);
        while (stringTokenizer.hasMoreTokens()) {
            set.add(stringTokenizer.nextToken());
        }
    }

    private void addField(Field field) {
        FieldDef fieldDef = new FieldDef(field.getName());
        Class<?> fieldType = field.getType();
        fieldDef.setType(BinaryClassParser.getTypeDef(fieldType));
        fieldDef.setDimensions(BinaryClassParser.getDimension(fieldType));
        fieldDef.setEnumConstant(field.isEnumConstant());
        BinaryClassParser.addModifiers(fieldDef.getModifiers(), field.getModifiers());
        this.binaryBuilder.beginField(fieldDef);
        this.binaryBuilder.endField();
    }

    private MethodDef createMethodDef(Member member) {
        int j2;
        Class<?>[] parameterTypes;
        Class<?>[] exceptions;
        MethodDef methodDef = new MethodDef();
        int lastDot = member.getName().lastIndexOf(46);
        methodDef.setName(member.getName().substring(lastDot + 1));
        BinaryClassParser.addModifiers(methodDef.getModifiers(), member.getModifiers());
        if (member instanceof Method) {
            methodDef.setConstructor(false);
            exceptions = ((Method)member).getExceptionTypes();
            parameterTypes = ((Method)member).getParameterTypes();
            Class<?> returnType = ((Method)member).getReturnType();
            methodDef.setReturnType(BinaryClassParser.getTypeDef(returnType));
            methodDef.setDimensions(BinaryClassParser.getDimension(returnType));
        } else {
            methodDef.setConstructor(true);
            exceptions = ((Constructor)member).getExceptionTypes();
            parameterTypes = ((Constructor)member).getParameterTypes();
        }
        for (j2 = 0; j2 < exceptions.length; ++j2) {
            Class<?> exception = exceptions[j2];
            methodDef.getExceptions().add(BinaryClassParser.getTypeDef(exception));
        }
        for (j2 = 0; j2 < parameterTypes.length; ++j2) {
            FieldDef param = new FieldDef("p" + j2);
            Class<?> parameterType = parameterTypes[j2];
            param.setType(BinaryClassParser.getTypeDef(parameterType));
            param.setDimensions(BinaryClassParser.getDimension(parameterType));
            this.binaryBuilder.addParameter(param);
        }
        return methodDef;
    }

    private static int getDimension(Class<?> c2) {
        return c2.getName().lastIndexOf(91) + 1;
    }

    private static String getTypeName(Class<?> c2) {
        return c2.getComponentType() != null ? c2.getComponentType().getName() : c2.getName();
    }

    private static TypeDef getTypeDef(Class<?> c2) {
        return new TypeDef(BinaryClassParser.getTypeName(c2));
    }
}

