/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers.TaggedFieldSerializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.Util;

public interface SerializerFactory<T extends Serializer> {
    public T newSerializer(Kryo var1, Class var2);

    public boolean isSupported(Class var1);

    public static class TaggedFieldSerializerFactory
    extends BaseSerializerFactory<TaggedFieldSerializer> {
        private final TaggedFieldSerializer.TaggedFieldSerializerConfig config = new TaggedFieldSerializer.TaggedFieldSerializerConfig();

        public TaggedFieldSerializer.TaggedFieldSerializerConfig getConfig() {
            return this.config;
        }

        @Override
        public TaggedFieldSerializer newSerializer(Kryo kryo, Class type) {
            return new TaggedFieldSerializer(kryo, type, this.config.clone());
        }
    }

    public static class FieldSerializerFactory
    extends BaseSerializerFactory<FieldSerializer> {
        private final FieldSerializer.FieldSerializerConfig config = new FieldSerializer.FieldSerializerConfig();

        @Override
        public FieldSerializer newSerializer(Kryo kryo, Class type) {
            return new FieldSerializer(kryo, type, this.config.clone());
        }
    }

    public static class SingletonSerializerFactory<T extends Serializer>
    extends BaseSerializerFactory<T> {
        private final T serializer;

        public SingletonSerializerFactory(T serializer) {
            this.serializer = serializer;
        }

        @Override
        public T newSerializer(Kryo kryo, Class type) {
            return this.serializer;
        }
    }

    public static class ReflectionSerializerFactory<T extends Serializer>
    extends BaseSerializerFactory<T> {
        private final Class<T> serializerClass;

        public ReflectionSerializerFactory(Class<T> serializerClass) {
            this.serializerClass = serializerClass;
        }

        @Override
        public T newSerializer(Kryo kryo, Class type) {
            return ReflectionSerializerFactory.newSerializer(kryo, this.serializerClass, type);
        }

        public static <T extends Serializer> T newSerializer(Kryo kryo, Class<T> serializerClass, Class type) {
            try {
                try {
                    return (T)((Serializer)serializerClass.getConstructor(Kryo.class, Class.class).newInstance(kryo, type));
                }
                catch (NoSuchMethodException ex1) {
                    try {
                        return (T)((Serializer)serializerClass.getConstructor(Kryo.class).newInstance(kryo));
                    }
                    catch (NoSuchMethodException ex2) {
                        try {
                            return (T)((Serializer)serializerClass.getConstructor(Class.class).newInstance(type));
                        }
                        catch (NoSuchMethodException ex3) {
                            return (T)((Serializer)serializerClass.newInstance());
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + Util.className(type), ex);
            }
        }
    }

    public static abstract class BaseSerializerFactory<T extends Serializer>
    implements SerializerFactory<T> {
        @Override
        public boolean isSupported(Class type) {
            return true;
        }
    }
}

