/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.pool;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.pool.KryoCallback;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.pool.KryoFactory;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.pool.KryoPoolQueueImpl;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.pool.SoftReferenceQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public interface KryoPool {
    public <T> T run(KryoCallback<T> var1);

    public static class Builder {
        private final KryoFactory factory;
        private Queue<Kryo> queue = new ConcurrentLinkedQueue<Kryo>();
        private boolean softReferences;

        public Builder(KryoFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException("factory must not be null");
            }
            this.factory = factory;
        }

        public Builder softReferences() {
            this.softReferences = true;
            return this;
        }

        public KryoPool build() {
            Queue<Kryo> q2 = this.softReferences ? new SoftReferenceQueue(this.queue) : this.queue;
            return new KryoPoolQueueImpl(this.factory, q2);
        }

        public String toString() {
            return this.getClass().getName() + "[queue.class=" + this.queue.getClass() + ", softReferences=" + this.softReferences + "]";
        }
    }
}

