/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.SourceLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModule;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SourceFolderLibrary
extends SourceLibrary {
    private List<File> sourceFolders = new LinkedList<File>();

    public SourceFolderLibrary(AbstractClassLibrary parent) {
        super(parent);
    }

    public JavaModule addSourceFolder(File sourceFolder) {
        this.sourceFolders.add(sourceFolder);
        return this.resolveJavaModule(sourceFolder);
    }

    private JavaModule resolveJavaModule(File sourceFolder) {
        JavaModule result = null;
        File moduleInfoFile = new File(sourceFolder, "module-info.java");
        if (moduleInfoFile.isFile()) {
            try {
                result = this.parse(new FileReader(moduleInfoFile), moduleInfoFile.toURI().toURL()).getModuleInfo();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    protected JavaClass resolveJavaClass(String className) {
        JavaClass result = super.resolveJavaClass(className);
        for (File sourceFolder : this.sourceFolders) {
            String mainClassName;
            File classFile = new File(sourceFolder, (mainClassName = className.split("\\$")[0]).replace('.', File.separatorChar) + ".java");
            if (!classFile.isFile()) continue;
            try {
                JavaSource source = this.parse(new FileReader(classFile), classFile.toURI().toURL()).getSource();
                result = source.getClassByName(className);
                break;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return result;
    }

    @Override
    protected boolean containsClassReference(String className) {
        boolean result = super.containsClassReference(className);
        Iterator<File> iterator = this.sourceFolders.iterator();
        while (!result && iterator.hasNext()) {
            String mainClassName;
            File sourceFolder = iterator.next();
            File classFile = new File(sourceFolder, (mainClassName = className.split("\\$")[0]).replace('.', File.separatorChar) + ".java");
            result = classFile.exists() && classFile.isFile();
        }
        return result;
    }
}

