/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils;

import java.io.DataInput;
import java.io.IOException;

public final class ByteUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static long fromLittleEndian(DataInput in, int length) throws IOException {
        ByteUtils.checkReadLength(length);
        long l2 = 0L;
        for (int i2 = 0; i2 < length; ++i2) {
            long b2 = in.readUnsignedByte();
            l2 |= b2 << i2 * 8;
        }
        return l2;
    }

    private static void checkReadLength(int length) {
        if (length > 8) {
            throw new IllegalArgumentException("Can't read more than eight bytes into a long value");
        }
    }
}

