/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.AndFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.DirectoryFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.NameFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.NotFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.OrFileFilter;
import java.util.ArrayList;
import java.util.List;

public class FileFilterUtils {
    private static final IOFileFilter cvsFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter("CVS")));
    private static final IOFileFilter svnFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(".svn")));

    public static IOFileFilter nameFileFilter(String name) {
        return new NameFileFilter(name);
    }

    public static IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.DIRECTORY;
    }

    public static IOFileFilter and(IOFileFilter ... filters) {
        return new AndFileFilter(FileFilterUtils.toList(filters));
    }

    public static IOFileFilter or(IOFileFilter ... filters) {
        return new OrFileFilter(FileFilterUtils.toList(filters));
    }

    public static List<IOFileFilter> toList(IOFileFilter ... filters) {
        if (filters == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        ArrayList<IOFileFilter> list = new ArrayList<IOFileFilter>(filters.length);
        for (int i2 = 0; i2 < filters.length; ++i2) {
            if (filters[i2] == null) {
                throw new IllegalArgumentException("The filter[" + i2 + "] is null");
            }
            list.add(filters[i2]);
        }
        return list;
    }

    public static IOFileFilter notFileFilter(IOFileFilter filter) {
        return new NotFileFilter(filter);
    }
}

